% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/internal.R
\name{.phase_diff}
\alias{.phase_diff}
\title{Compute Phase Difference Between Two Signals}
\usage{
.phase_diff(a, b)
}
\arguments{
\item{a}{A \code{fftab} object or signal representing the first input.}

\item{b}{A \code{fftab} object or signal representing the second input.}
}
\value{
A numeric value representing the \strong{phase difference} (in radians) between the two signals.
}
\description{
Computes the phase difference between two signals based on their cross-spectrum,
with symmetric and redundant frequency components removed.
}
\details{
This function computes the \strong{cross-spectrum} of two signals, removes symmetric and redundant
frequency components, converts the result into polar representation, weights the phase angles
by their magnitudes, and calculates the weighted average phase difference.

Removing symmetric components ensures accurate phase alignment, avoiding ambiguity caused
by redundant negative frequencies.
}
\keyword{internal}
