% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fglsnet.R
\name{fglsnet}
\alias{fglsnet}
\title{A Feasible Generalized Least Squares Estimator for Regression Analysis of Outcomes with Network Dependence}
\usage{
fglsnet(
  formula,
  M = NULL,
  directed = TRUE,
  mcorr = TRUE,
  CSE = FALSE,
  k = 10,
  data = data
)
}
\arguments{
\item{formula}{A formula indicating the regression model.}

\item{M}{The dependence network.}

\item{directed}{Whether the dependence network is directed or undirected.}

\item{mcorr}{Whether request multiple correlation coefficients to distinguish triadic, mutual, and asymmetric error dependence.}

\item{CSE}{Whether use clustered standard error for the residual regression. Default cluster is the ego unit.}

\item{k}{The number of iterations in the fgls estimation.}

\item{data}{The data that are used for the regression.}
}
\value{
A list containing the coefficient \code{coef}, the testing results on the error correlations \code{rtest}, 
the estimated error variance \code{Sigma}, the estimated error correlation matrix \code{Omega}, and the OLS estimates \code{ols}.
}
\description{
\code{fglsnet} estimates a multivariate regression model for analyzing outcomes with network dependence. 
One nice feature of the function is that it can distinguish three types of error dependence, 
including triadic dependence, mutual dependence, and asymmetric dependence.
}
\details{
The function estimates a multivariate regression model for analyzing outcomes with network dependence.
One nice feature of the function is that it can distinguish three types of error dependence, 
including triadic dependence, mutual dependence, and asymmetric dependence.
}
\examples{
data(dat)

g <- fglsnet(Y~ X-1, M = dat$M, directed = TRUE, mcorr = 1, k = 5, data = dat)

g$coef

}
\references{
An, Weihua. 2023. ``A Tale of Twin-Dependence: A New Multivariate Regression Model and an FGLS Estimator for Analyzing Outcomes with Network Dependence." \emph{Sociological Methods and Research} 52(4): 1947-1980. 

Greene, William H. (2008). \emph{Econometric Analysis} (6th edition). New Jersey: Pearson Prentice Hall.\cr
}
