% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/response.R
\name{select_any_of}
\alias{select_any_of}
\title{Select any of the elements in a object}
\usage{
select_any_of(x, elements)
}
\arguments{
\item{x}{A object with \code{names} attribute (usually a named R list);}

\item{elements}{A vector of strings with the name of the elements to search for;}
}
\value{
A subset of the \code{x} if it finds any of the elements described in the
  \code{element} argument.
}
\description{
Safely select elements of a named object (like a named R list).
}
\details{
This functions works in a similar way to \code{dplyr::any_of()}. It tries
to select any element of \code{x} that is in the vector given by the user
in the \code{elements} argument.

In other words, if the user gives the vector \code{c("a", "c", "e")}, \code{select_any_of()}
will search for elements "a", "c" and "e" in the \code{x} object, and will select
any of these elements if it finds them.

But \code{dplyr::any_of()} is designed to work with columns of a data.frame,
and \code{figma::select_any_of()} is designed to work specially with elements of a
named list (although it can be used to select columns of a data.frames as well).
}
