% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/finnishgrid.R
\name{border_da_trans_cap_FI_EE_official}
\alias{border_da_trans_cap_FI_EE_official}
\title{Day-ahead transmission capacity FI-EE - official}
\usage{
border_da_trans_cap_FI_EE_official(
  start_time_utc = NA,
  end_time_utc = NA,
  user_key = NA
)
}
\arguments{
\item{start_time_utc}{Start time in UTC. Character array YYYY-MM-ddTHH:mm:ss.sssZ}

\item{end_time_utc}{End time in UTC. Character array YYYY-MM-ddTHH:mm:ss.sssZ}

\item{user_key}{Character array holding API-key.
Free from https://data.fingrid.fi/en/instructions}
}
\value{
A data frame object with time series data having period 1 h and unit type MW.
}
\description{
Day-ahead transmission capacity from Finland (FI) to Estonia (EE). Transmission capacity is given hourly for every hour of the next day. Each hour is given one value. Day-ahead transmission capacity Fingrid will publish every day in the afternoon. This capacity will not changed after publication. Transmission capacity mean the capability of the electricity system to supply electricity to the market without compromising the system security.
}
\examples{
\dontrun{
library(finnishgrid)
start = "2024-06-01T00:00:00.000Z"  # UTC
end = "2024-06-03T00:00:00.000Z"    # UTC
key = "MY_SUPER_SECRET"
df <- border_da_trans_cap_FI_EE_official(start_time_utc = start,
         end_time_utc = end,
         user_key = key)
summary(df)
}
}
\seealso{
https://data.fingrid.fi/en/datasets/115
}
