% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/finnishgrid.R
\name{imbalance_power_FI_SE}
\alias{imbalance_power_FI_SE}
\title{Imbalance power between Finland and Sweden}
\usage{
imbalance_power_FI_SE(start_time_utc = NA, end_time_utc = NA, user_key = NA)
}
\arguments{
\item{start_time_utc}{Start time in UTC. Character array YYYY-MM-ddTHH:mm:ss.sssZ}

\item{end_time_utc}{End time in UTC. Character array YYYY-MM-ddTHH:mm:ss.sssZ}

\item{user_key}{Character array holding API-key.
Free from https://data.fingrid.fi/en/instructions}
}
\value{
A data frame object with time series data having period 1 h and unit type MWh/h.
}
\description{
The volume of power equals to the difference between measured and commercial transmission between Finland and Sweden. The tradetypes of commercial flow include day ahead, intraday and trades between Fingrid and Svenska Kraftnät during the operational hour.When the value of imbalance power volume is positive Fingrid has sold imbalance power to Sweden. When the value of imbalance power volume is negative Fingrid has bought imbalance power from Sweden.
}
\examples{
\dontrun{
library(finnishgrid)
start = "2024-06-01T00:00:00.000Z"  # UTC
end = "2024-06-03T00:00:00.000Z"    # UTC
key = "MY_SUPER_SECRET"
df <- imbalance_power_FI_SE(start_time_utc = start,
         end_time_utc = end,
         user_key = key)
summary(df)
}
}
\seealso{
https://data.fingrid.fi/en/datasets/176
}
