% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_user_data.R
\name{get_user_data}
\alias{get_user_data}
\title{Get user data from firebase}
\usage{
get_user_data(id_token)
}
\arguments{
\item{id_token}{String. The Firebase ID token of the account.}
}
\value{
A named list with the following items:
\itemize{
\item \code{users}: A list of length 1 which contains a nested named list with the
following items:
\itemize{
\item \code{localId}: The uid of the current user.
\item \code{email}: The email of the account.
\item \code{emailVerified}: Whether or not the account's email has been verified.
\item \code{displayName}: The display name for the account.
\item \code{providerUserInfo}: Named list of provider objects which contain
"providerId" and "federatedId".
\item \code{photoUrl}: The photo Url for the account.
\item \code{passwordHash}: Hash version of password.
\item \code{passwordUpdatedAt}: The timestamp, in milliseconds, that the account
password was last changed.
\item \code{validSince}: The timestamp, in milliseconds, which marks a boundary,
before which Firebase ID token are considered revoked.
\item \code{disabled}: Whether the account is disabled or not.
\item \code{lastLoginAt}: The timestamp, in milliseconds, that the account last
logged in at.
\item \code{createdAt}: The timestamp, in milliseconds, that the account was
created at.
\item \code{customAuth}: Whether the account is authenticated by the developer.
}
\item \code{error}:
\itemize{
\item \code{NULL} if no error code in response
\item A list of 2 if response was an error:
\itemize{
\item \code{code}: Error code
\item \code{message}: Error message
}
}
}
}
\description{
Get user data from firebase
}
\details{
Visit \href{https://firebase.google.com/docs/reference/rest/auth#section-get-account-info}{Firebase Auth REST API docs}
for more details
}
\examples{
\dontrun{
  user_data <- get_user_data("<id_token>")
  lapply(user_data, `[[`, 1)
}
}
