% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-auth.R
\name{FirebaseAuth}
\alias{FirebaseAuth}
\title{Firebase Authentication}
\value{
An object of class \code{FirebaseAuth}.
}
\description{
Use firebase to manage authentications.
}
\section{Super class}{
\code{\link[firebase:Firebase]{firebase::Firebase}} -> \code{FirebaseAuth}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{signed_in}}{Read the signed in user.}

\item{\code{signed_up}}{Read the signed in user.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-FirebaseAuth-new}{\code{FirebaseAuth$new()}}
\item \href{#method-FirebaseAuth-print}{\code{FirebaseAuth$print()}}
\item \href{#method-FirebaseAuth-sign_out}{\code{FirebaseAuth$sign_out()}}
\item \href{#method-FirebaseAuth-get_sign_out}{\code{FirebaseAuth$get_sign_out()}}
\item \href{#method-FirebaseAuth-get_signed_in}{\code{FirebaseAuth$get_signed_in()}}
\item \href{#method-FirebaseAuth-get_signed_up}{\code{FirebaseAuth$get_signed_up()}}
\item \href{#method-FirebaseAuth-is_signed_in}{\code{FirebaseAuth$is_signed_in()}}
\item \href{#method-FirebaseAuth-req_sign_in}{\code{FirebaseAuth$req_sign_in()}}
\item \href{#method-FirebaseAuth-req_sign_out}{\code{FirebaseAuth$req_sign_out()}}
\item \href{#method-FirebaseAuth-set_language_code}{\code{FirebaseAuth$set_language_code()}}
\item \href{#method-FirebaseAuth-delete_user}{\code{FirebaseAuth$delete_user()}}
\item \href{#method-FirebaseAuth-get_delete_user}{\code{FirebaseAuth$get_delete_user()}}
\item \href{#method-FirebaseAuth-expose_auth}{\code{FirebaseAuth$expose_auth()}}
\item \href{#method-FirebaseAuth-get_access_token}{\code{FirebaseAuth$get_access_token()}}
\item \href{#method-FirebaseAuth-clear}{\code{FirebaseAuth$clear()}}
\item \href{#method-FirebaseAuth-request_id_token}{\code{FirebaseAuth$request_id_token()}}
\item \href{#method-FirebaseAuth-get_id_token}{\code{FirebaseAuth$get_id_token()}}
\item \href{#method-FirebaseAuth-clone}{\code{FirebaseAuth$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="firebase" data-topic="Firebase" data-id="expose_app"><a href='../../firebase/html/Firebase.html#method-Firebase-expose_app'><code>firebase::Firebase$expose_app()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FirebaseAuth-new"></a>}}
\if{latex}{\out{\hypertarget{method-FirebaseAuth-new}{}}}
\subsection{Method \code{new()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FirebaseAuth$new(
  persistence = c("session", "local", "memory"),
  config_path = "firebase.rds",
  language_code = NULL,
  session = shiny::getDefaultReactiveDomain()
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{persistence}}{How the auth should persit: \code{none}, the user has to sign in at every visit,
\code{session} will only persist in current tab, \code{local} persist even when window is closed.}

\item{\code{config_path}}{Path to the configuration file as created by \code{\link{firebase_config}}.}

\item{\code{language_code}}{Sets the language to use for the UI.
Supported languages are listed \href{https://github.com/firebase/firebaseui-web/blob/master/LANGUAGES.md}{here}.
Set to \code{browser} to use the default browser language of the user.}

\item{\code{session}}{A valid shiny session.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Initialise firebase authentication
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FirebaseAuth-print"></a>}}
\if{latex}{\out{\hypertarget{method-FirebaseAuth-print}{}}}
\subsection{Method \code{print()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FirebaseAuth$print()}\if{html}{\out{</div>}}
}

\subsection{Details}{
Print the class
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FirebaseAuth-sign_out"></a>}}
\if{latex}{\out{\hypertarget{method-FirebaseAuth-sign_out}{}}}
\subsection{Method \code{sign_out()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FirebaseAuth$sign_out()}\if{html}{\out{</div>}}
}

\subsection{Details}{
Signs out user
}

\subsection{Returns}{
self
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FirebaseAuth-get_sign_out"></a>}}
\if{latex}{\out{\hypertarget{method-FirebaseAuth-get_sign_out}{}}}
\subsection{Method \code{get_sign_out()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FirebaseAuth$get_sign_out()}\if{html}{\out{</div>}}
}

\subsection{Details}{
Get signed out results
}

\subsection{Returns}{
A list of length 2 containing \code{success} a boolean
indicating wherther signing out was successful and \code{response}
containing \code{sucessful} or the error.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FirebaseAuth-get_signed_in"></a>}}
\if{latex}{\out{\hypertarget{method-FirebaseAuth-get_signed_in}{}}}
\subsection{Method \code{get_signed_in()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FirebaseAuth$get_signed_in()}\if{html}{\out{</div>}}
}

\subsection{Details}{
Signed in user details triggered when auth states changes
}

\subsection{Returns}{
A list of length 2 containing \code{success} a boolean
indicating wherther signing in was successful and \code{response}
containing the user object or \code{NULL} if signing in failed.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FirebaseAuth-get_signed_up"></a>}}
\if{latex}{\out{\hypertarget{method-FirebaseAuth-get_signed_up}{}}}
\subsection{Method \code{get_signed_up()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FirebaseAuth$get_signed_up()}\if{html}{\out{</div>}}
}

\subsection{Details}{
Get results of a sign up
}

\subsection{Returns}{
A list of length 2 containing \code{success} a boolean
indicating wherther signing in was successful and \code{response}
containing the user object or \code{NULL} if signing in failed.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FirebaseAuth-is_signed_in"></a>}}
\if{latex}{\out{\hypertarget{method-FirebaseAuth-is_signed_in}{}}}
\subsection{Method \code{is_signed_in()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FirebaseAuth$is_signed_in()}\if{html}{\out{</div>}}
}

\subsection{Details}{
Check whether use is signed in
}

\subsection{Returns}{
A boolean indicating whether user has successfully signed in.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FirebaseAuth-req_sign_in"></a>}}
\if{latex}{\out{\hypertarget{method-FirebaseAuth-req_sign_in}{}}}
\subsection{Method \code{req_sign_in()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FirebaseAuth$req_sign_in()}\if{html}{\out{</div>}}
}

\subsection{Details}{
Makes Shiny output, observer, or reactive require the user to be signed in
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FirebaseAuth-req_sign_out"></a>}}
\if{latex}{\out{\hypertarget{method-FirebaseAuth-req_sign_out}{}}}
\subsection{Method \code{req_sign_out()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FirebaseAuth$req_sign_out()}\if{html}{\out{</div>}}
}

\subsection{Details}{
Makes Shiny output, observer, or reactive require the user to be signed out
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FirebaseAuth-set_language_code"></a>}}
\if{latex}{\out{\hypertarget{method-FirebaseAuth-set_language_code}{}}}
\subsection{Method \code{set_language_code()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FirebaseAuth$set_language_code(code)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{code}}{iso639-1 language code.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Set language code for auth provider
}

\subsection{Returns}{
self
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FirebaseAuth-delete_user"></a>}}
\if{latex}{\out{\hypertarget{method-FirebaseAuth-delete_user}{}}}
\subsection{Method \code{delete_user()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FirebaseAuth$delete_user()}\if{html}{\out{</div>}}
}

\subsection{Details}{
Delete the user
}

\subsection{Returns}{
self
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FirebaseAuth-get_delete_user"></a>}}
\if{latex}{\out{\hypertarget{method-FirebaseAuth-get_delete_user}{}}}
\subsection{Method \code{get_delete_user()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FirebaseAuth$get_delete_user()}\if{html}{\out{</div>}}
}

\subsection{Details}{
Get result of user deletion
}

\subsection{Returns}{
A list of length 2 containing \code{success} a boolean
indicating wherther deletion was successful and \code{response}
containing either \code{successful} string or the error if signing in failed.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FirebaseAuth-expose_auth"></a>}}
\if{latex}{\out{\hypertarget{method-FirebaseAuth-expose_auth}{}}}
\subsection{Method \code{expose_auth()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FirebaseAuth$expose_auth()}\if{html}{\out{</div>}}
}

\subsection{Details}{
Expose Auth

Expose the \code{firebaseAuth} object the product of the authentication
attaching it to the \code{window}: access it with \code{window.firebaseAuth}.
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FirebaseAuth-get_access_token"></a>}}
\if{latex}{\out{\hypertarget{method-FirebaseAuth-get_access_token}{}}}
\subsection{Method \code{get_access_token()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FirebaseAuth$get_access_token()}\if{html}{\out{</div>}}
}

\subsection{Details}{
Get user access token
}

\subsection{Returns}{
User's access token
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FirebaseAuth-clear"></a>}}
\if{latex}{\out{\hypertarget{method-FirebaseAuth-clear}{}}}
\subsection{Method \code{clear()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FirebaseAuth$clear()}\if{html}{\out{</div>}}
}

\subsection{Details}{
Clear user session

This clears the login internally and will retrigger a JWT
token check, only useful if you are running really long
sessions.
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FirebaseAuth-request_id_token"></a>}}
\if{latex}{\out{\hypertarget{method-FirebaseAuth-request_id_token}{}}}
\subsection{Method \code{request_id_token()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FirebaseAuth$request_id_token()}\if{html}{\out{</div>}}
}

\subsection{Details}{
Request the users' ID Token

Used to retrieved the user's ID token useful to connect
with other Google APIs and make request on the user's behalf.
This executes the request for the id token, this request
can only be made once the user is signed in.

The actual id token is obtained with the \code{get_id_token}
method.
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FirebaseAuth-get_id_token"></a>}}
\if{latex}{\out{\hypertarget{method-FirebaseAuth-get_id_token}{}}}
\subsection{Method \code{get_id_token()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FirebaseAuth$get_id_token()}\if{html}{\out{</div>}}
}

\subsection{Details}{
Retrieve the users' ID Token

Also see \code{request_id_token}.
}

\subsection{Returns}{
the id token (invisibly).
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FirebaseAuth-clone"></a>}}
\if{latex}{\out{\hypertarget{method-FirebaseAuth-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FirebaseAuth$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
