% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitPolyTools.R
\name{F1Dosages2Matrix}
\alias{F1Dosages2Matrix}
\title{Convert the F1 dosage scores data.frame or file to polymapR
input matrix}
\usage{
F1Dosages2Matrix(dosages, outfile=NA, dec=".", sep=",")
}
\arguments{
\item{dosages}{name of an F1 dosage scores file as produced by functions
writeDosagefile, compareProbes or removeRedundant, or a data frame
read from such a file}

\item{outfile}{(path and) name of an output file, default NA means that no
file is written. The file is written by function writeDatfile; normally using
the default parameters but if file extension is 'csv', quote is set to TRUE
and the specified dec and sep parameters are used}

\item{dec}{character to use as decimal separator in the output file,
default "."; only used if extension of outfile is 'csv' (otherwise ".")}

\item{sep}{character to use as field separator in the output file,
default ","; only used if extension of outfile is 'csv' (otherwise
tab character)}
}
\value{
A matrix as needed by the polymapR package: one row per marker,
one column per sample, containing integer scores (0 .. ploidy) or NAs.
Row names are marker names, column names are sample names; the first two
columns are the (consensus) scores of Parent1 and Parent2.\cr
If outfile is not NA also an output file is written: if the extension is
'csv' a csv file is written with the specified decimal and field separators
(default '.' and ',') and with row and column names quoted, else a
tab-separated file.
}
\description{
Functions writeDosagefile, compareProbes and removeRedundant
produce score files. This function reads such a file and converts the result
to a data.frame as needed by the polymapR package.
}
