% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vectorfield_landscape.R
\name{fit_3d_vfld}
\alias{fit_3d_vfld}
\title{Estimate a 3D potential landscape from a vector field}
\usage{
fit_3d_vfld(
  vf,
  method = c("simlandr", "pathB"),
  .pathB_options = pathB_options(vf),
  .sim_vf_options = sim_vf_options(vf),
  .simlandr_options = simlandr_options(vf),
  linear_interp = FALSE
)
}
\arguments{
\item{vf}{A \code{vectorfield} object estimated by \code{\link[=fit_2d_vf]{fit_2d_vf()}}.}

\item{method}{The method used for landscape construction. Can be \code{pathB} or \code{simlandr}.}

\item{.pathB_options}{Only for \code{method = "pathB"}. Options controlling the path-integral algorithm. Should be generated by \code{\link[=sim_vf_options]{sim_vf_options()}}.}

\item{.sim_vf_options}{Only for \code{method = "simlandr"}. Options controlling the vector field simulation. Should be generated by \code{\link[=sim_vf_options]{sim_vf_options()}}.}

\item{.simlandr_options}{Only for \code{method = "simlandr"}. Options controlling the landscape construction. Should be generated by \code{\link[=simlandr_options]{simlandr_options()}}.}

\item{linear_interp}{Use linear interpolation method to estimate the drift vector (and the diffusion matrix). This can speed up the calculation. If \code{TRUE}, be sure that a linear grid was calculated for the vector field using \verb{<vf> <- add_interp_grid(<vf>)}.}
}
\value{
A \code{landscape} object as described in \code{\link[simlandr:make_3d_static]{simlandr::make_3d_static()}}, or a \verb{3d_static_landscape_B} object, which inherits from the \code{landscape} class and contains the following elements: \code{dist}, the distribution estimation for landscapes; \code{plot}, a 3D plot using \code{plotly}; plot_2, a 2D plot using \code{ggplot2}; x, y, from \code{vf}.
}
\description{
Two methods are available: \code{method = "pathB"} and \code{method = "simlandr"}. See \emph{Details} section.
}
\details{
For \code{method = "simlandr"}, the landscape is constructed based on the generalized potential landscape by Wang et al. (2008), implemented by the \code{simlandr} package. This function is a wrapper of \code{\link[=sim_vf]{sim_vf()}} and \code{\link[simlandr:make_3d_static]{simlandr::make_3d_static()}}. Use those two functions separately for more customization.

For \code{method = "pathB"}, the landscape is constructed based on the deterministic path-integral quasi-potential defined by Bhattacharya et al. (2011).

We recommend the \code{simlandr} method for psychological data because it is more stable.

Parallel computing based on \code{future} is supported for both methods. Use \code{future::plan("multisession")} to enable this and speed up computation.
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# generate data
single_output_grad <- simlandr::sim_fun_grad(length = 200, seed = 1614)
# fit the vector field
v2 <- fit_2d_vf(single_output_grad, x = "x", y = "y", method = "MVKE")
plot(v2)
# fit the landscape
future::plan("multisession")
set.seed(1614)
l2 <- fit_3d_vfld(v2,
.sim_vf_options = sim_vf_options(chains = 16, stepsize = 1, forbid_overflow = TRUE),
.simlandr_options = simlandr_options(adjust = 5, Umax = 4))
plot(l2, 2)
future::plan("sequential")
\dontshow{\}) # examplesIf}
}
