% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitmixEM.R
\name{fitmixEM}
\alias{fitmixEM}
\title{Fits lifespan data of time units with gompertz, log-logistics, log-normal, and weibull mixture models choice of one.}
\usage{
fitmixEM(lifespan, model, K, initial = FALSE, starts)
}
\arguments{
\item{lifespan}{numeric vector of lifespan dataset}

\item{model}{model name of the one of the well-known model: \code{gompertz},\code{log-logistics},\code{log-normal}, and \code{weibull}.}

\item{K}{number of well-known model components.}

\item{initial}{logical true or false}

\item{starts}{numeric if initial sets to true}
}
\value{
1.The return has three values; the first value is estimate, measures, and cluster.

2. The second value includes four different measurements of goodness-of-fit tests involving:
Akaike Information Criterion \code{(AIC)}, Bayesian Information Criterion \code{(BIC)}, Kolmogorov-Smirnov \code{(KS)}, and log-likelihood \code{(log.likelihood)} statistics.

3. The last value is the output of clustering vector.
}
\description{
Fits lifespan data of time units with gompertz, log-logistics, log-normal, and weibull mixture models choice of one.
}
\details{
Estimates parameters of the given mixture model implementing the expectation maximization (EM) algorithm.
General form for the cdf of a statistical mixture model is given by
 a distribution f is a mixture of \code{K component} distributions of
\eqn{f = (f_1, f_2,..f_K)} if \deqn{f(x) = \sum_{k=1}^{K}\lambda_k f_k(x)} with
\eqn{\lambda_k > 0}, \eqn{\sum_k \lambda_k = 1}. This equation is a stochastic model, thus
it allows to generate new data points; first picks a distribution of choice, with
probablities by weight, then generates another observation according to the chosen distribution.
In short represenated by,
Z \code{~} Mult(\eqn{\lambda_1, \lambda_2,...\lambda_k)} and
X|Z \code{~ f_Z}, where \code{Z} is a discrete random variable which component X is drawn from.

The families considered for the cdf of Gompertz, Log-normal, Log-logistic, and Weibull.
}
\examples{
lifespan<-sample(1000)
fitmixEM(lifespan, "weibull", K = 2, initial = FALSE)
}
\references{
Farewell, V. (1982). The Use of Mixture Models for the Analysis of Survival Data with Long-Term Survivors. \emph{Biometrics, 38(4), 1041-1046}. doi:10.2307/2529885
McLachlan, G. J. and Peel, D. (2000) \emph{Finite Mixture Models}, John Wiley \& Sons, Inc.

Essam K. Al-Hussaini, Gannat R. Al-Dayian & Samia A. Adham (2000) On finite mixture of two-component gompertz lifetime model, \emph{Journal of Statistical Computation and Simulation, 67:1, 20-67}, DOI: 10.1080/00949650008812033
}
