% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3-methods.R
\name{fittedExposureEff}
\alias{fittedExposureEff}
\title{Fitted exposure effect values from Reversible Jump MCMC (rjMCMC) Model Results}
\usage{
fittedExposureEff(results, newdata = NULL)
}
\arguments{
\item{results}{An object of class rjMCMC containing the output from the \code{rjMCMC} procedure, which includes:
\describe{
\item{fixed_param}{Matrix of posterior samples for exposure intercept and main effect.}
\item{binary_param}{Matrix of posterior samples for binary variable parameters.}
\item{sigma_sq}{Matrix of posterior samples for the residual variance (sigma squared).}
\item{vars_prop_summ}{Posterior inclusion probabilities for candidate variables.}
\item{splines_fitted}{List of matrices containing fitted values for spline terms across iterations.}
\item{data_fit}{Original dataset used in the \code{rjMCMC} procedure.}
\item{candsplineinter}{Names of continuous candidate predictive spline variables.}
\item{candsplinevars}{Names of continuous candidate spline variables.}
\item{candbinaryvars}{Names of binary candidate variables.}
\item{candinter}{Names of interaction terms, which can include spline variables.}
\item{mcmc_specs}{MCMC sampler specifications, including the number of iterations, burn-in, thinning, and chains.}
}}

\item{newdata}{A data frame for which fitted values are to be computed. If NA, the original fitted data is used.}
}
\value{
A matrix of fitted values.
}
\description{
This function generates posterior fitted exposure effects from an rjMCMC model based on the provided data.
It combines the fixed effects, spline terms, and binary parameters.
}
\examples{
\donttest{
# Example dataset
data("simulated_data")

candsplinevars <- c("X_1")
candbinaryvars <- paste0("Z_", 1:5)
candinter <- c(candsplinevars, candbinaryvars)
results <- rjMCMC(simulated_data, candsplinevars, candbinaryvars, candinter,
                  outcome = "Y", factor_var = "trt")
newdata = data.frame(Z_1 = 1, Z_2 = 1, Z_3 = 1, Z_4 = 1, Z_5 = 1,
                   trt = 1, X_1 = seq(0,1,by=0.01))
fittedExposureEff(results)
fittedExposureEff(results,newdata)
}
}
