% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3-methods.R
\name{pip}
\alias{pip}
\title{Compute Posterior Inclusion Probabilities (PIPs) for rjMCMC Results}
\usage{
pip(results)
}
\arguments{
\item{results}{An object of class rjMCMC containing the output from the \code{rjMCMC} procedure, which includes:
\describe{
\item{fixed_param}{Matrix of posterior samples for exposure intercept and main effect.}
\item{binary_param}{Matrix of posterior samples for binary variable parameters.}
\item{sigma_sq}{Matrix of posterior samples for the residual variance (sigma squared).}
\item{vars_prop_summ}{Posterior inclusion probabilities for candidate variables.}
\item{splines_fitted}{List of matrices containing fitted values for spline terms across iterations.}
\item{data_fit}{Original dataset used in the \code{rjMCMC} procedure.}
\item{candsplineinter}{Names of continuous candidate predictive spline variables.}
\item{candsplinevars}{Names of continuous candidate spline variables.}
\item{candbinaryvars}{Names of binary candidate variables.}
\item{candinter}{Names of interaction terms, which can include spline variables.}
\item{mcmc_specs}{MCMC sampler specifications, including the number of iterations, burn-in, thinning, and chains.}
}}
}
\value{
A numeric vector with the PIPs for the intercept, exposure, and other variables.
}
\description{
This function returns the posterior inclusion probabilities (PIPs) for all variables,
including the intercept and exposure, based on the results from an rjMCMC model.
}
\examples{
\donttest{
# Example dataset
data("simulated_data")

candsplinevars <- c("X_1")
candbinaryvars <- paste0("Z_", 1:5)
candinter <- c(candsplinevars, candbinaryvars)

results <- rjMCMC(simulated_data, candsplinevars, candbinaryvars, candinter,
                  outcome = "Y", factor_var = "trt")
pip(results)
}
}
