% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rjMCMC.R
\name{rjMCMC}
\alias{rjMCMC}
\title{Run Reversible Jump MCMC (rjMCMC) Procedure}
\usage{
rjMCMC(
  data,
  candsplinevars,
  candbinaryvars,
  candinter,
  outcome,
  factor_var,
  mcmc_specs = NULL,
  prior_params = NULL
)
}
\arguments{
\item{data}{A data frame containing the observations, including the following columns:
\describe{
\item{factor_var}{Exposure group binary indicator.}
\item{outcome}{Continuous-valued outcome.}
\item{candsplinevars}{All candidate spline variables as described in \code{candsplinevars}.}
\item{candbinaryvars}{All candidate binary variables as described in \code{candbinaryvars}.}
}}

\item{candsplinevars}{A vector of names for continuous predictive candidate variables (default = NULL).}

\item{candbinaryvars}{A vector of names for binary predictive candidate variables (default = NULL).}

\item{candinter}{A vector indicating which of the candidate variables are tailoring (default = NULL).}

\item{outcome}{A string indicating the name of the continuous outcome variable in data.}

\item{factor_var}{A string indicating the name of the binary exposure variable in data.}

\item{mcmc_specs}{A list containing:
\describe{
\item{iter}{Number of total iterations per chain (including warmup; default = 4000).}
\item{warmup}{Number of warmup/burn-in samples per chain (default = 2000).}
\item{thin}{Thinning parameter (default = 1).}
\item{chain}{Number of chains (default = 4).}
\item{sigma_v}{Proposal variance for "jump" terms (default = 0.1).}
\item{bma}{Boolean indicating whether to include Bayesian model averaging step (default = TRUE).}
}}

\item{prior_params}{A list containing prior parameters:
\describe{
\item{lambda_1}{Prior parameter for the number of terms in the model (default = 0.1).}
\item{lambda_2}{Prior parameter for the number of knots in each spline (default = 1).}
\item{a_0}{Shape parameter for inverse gamma prior on individual-level variance (default = 0.01).}
\item{b_0}{Rate parameter for inverse gamma prior on individual-level variance (default = 0.01).}
\item{degree}{Degree of B-splines (default = 3).}
\item{k_max}{Maximum number of knots for each spline term (default = 9).}
\item{w}{Window for proposing knot location changes (default = 1).}
\item{sigma_B}{Prior normal variance for model coefficients (default = sqrt(20)).}
}}
}
\value{
An rjMCMC object with the following components:
\describe{
\item{accept_var}{Matrix indicating the acceptance of variable inclusion/removal for each iteration.}
\item{accept_add_knot}{Matrix indicating acceptance of knot addition for each spline term across iterations.}
\item{accept_remove_knot}{Matrix indicating acceptance of knot removal for each spline term across iterations.}
\item{accept_move_knot}{Matrix indicating acceptance of knot movement for each spline term across iterations.}
\item{splines_fitted}{List of matrices, one per spline interaction term, containing fitted spline values across iterations.}
\item{binary_param}{Matrix containing posterior samples of binary variable parameters.}
\item{inter_trt_param}{Matrix containing posterior samples of the treatment intercept and main effect.}
\item{sigma_sq}{Matrix of posterior samples for the residual variance (sigma squared).}
\item{vars_prop}{Matrix indicating the inclusion of variables across iterations (1 for included, 0 for excluded).}
\item{vars_prop_summ}{Posterior inclusion probabilities for all candidate variables (spline and binary).}
\item{k}{Matrix indicating the number of knots for each spline term across iterations.}
\item{trt_eff_posterior}{Matrix of posterior treatment effect estimates, including spline effects.}
\item{data_fit}{The original dataset passed to the function.}
\item{candsplineinter}{A character vector indicating the spline interaction terms.}
\item{candsplinevars}{A character vector of candidate spline variables.}
\item{candbinaryvars}{A character vector of candidate binary variables.}
\item{candinter}{A character vector of interaction terms with treatment (can include splines and binary variables).}
\item{mcmc_specs}{The MCMC specifications used in the procedure.}
\item{prior_params}{The prior parameters used in the procedure.}
}
}
\description{
This function performs a Reversible Jump MCMC (rjMCMC) procedure to generate the posterior distribution,
using Bayesian model averaging and free-knot B-splines.
}
\examples{
\donttest{
# Example dataset
data("simulated_data")

candsplinevars <- c("X_1")
candbinaryvars <- paste0("Z_", 1:5)
candinter <- c(candsplinevars, candbinaryvars)

results <- rjMCMC(simulated_data, candsplinevars, candbinaryvars, candinter,
                  outcome = "Y", factor_var = "trt")
}
}
\references{
Maleyeff, L., Golchi, S., Moodie, E. E. M., & Hudson, M. (2024) "An adaptive
enrichment design using Bayesian model averaging for selection and threshold-identification
of predictive variables" \url{doi:10.1093/biomtc/ujae141}
}
