% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flag_weighted.R
\name{flag_weighted}
\alias{flag_weighted}
\title{Flag aggregation by the weighted frequency method}
\usage{
flag_weighted(i, f, w)
}
\arguments{
\item{i}{An integer column identifier of data.frame or a matrix containing the flags and weights used to derived
the flag for the aggregates.}

\item{f}{A data.frame or a matrix containing the flags of the series (one column per period)}

\item{w}{A data.frame or a matrix with same size and dimesion as \code{f} containing the corresponding weights
for each flags.}
}
\value{
\code{flag_weighted} Returns a character vector with the flag that has the highest weighted frequency or multiple flags in alphabetical 
order (in case there are more than one flag with the same highest weight) as the first value, and the sum of weights for the given flag(s) as 
the second value for the given columns of \code{f,w} defined by the parameter \code{i}.
}
\description{
This method can be used when you want to derive the flag of an aggregate that is a weighted average,
index, quantile, etc.
}
\examples{
flag_weighted(1, 
              data.frame(f=c("pe","b","p","p","u","e","d"), stringsAsFactors = FALSE), 
              data.frame(w=c(10,3,7,12,31,9,54)))
flag_weighted(1, 
              data.frame(f=c("pe","b","p","p","up","e","d"), stringsAsFactors = FALSE),
              data.frame(w=c(10,3,7,12,31,9,54)))
flag_weighted(1, 
              data.frame(f=c("pe",NA,"pe",NA,NA,"d"), stringsAsFactors = FALSE),
              data.frame(w=c(10,3,7,12,31,9)))


flags <- tidyr::spread(test_data[, c(1:3)], key = time, value = flags)
weights <- tidyr::spread(test_data[, c(1, 3:4)], key = time, value = values)
flag_weighted(7,flags[, c(2:ncol(flags))],weights[, c(2:ncol(weights))])

weights<-apply(weights[, c(2:ncol(weights))],2,function(x) x/sum(x,na.rm=TRUE))
weights[is.na(weights)] <- 0
flags<-flags[, c(2:ncol(flags))]
sapply(1:ncol(flags),flag_weighted,f=flags,w=weights)

}
\seealso{
\code{\link{flag_divide}}
}
