% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/StatMixHMM.R
\docType{class}
\name{StatMixHMM-class}
\alias{StatMixHMM-class}
\alias{StatMixHMM}
\title{A Reference Class which contains statistics of a mixture of HMM model.}
\description{
StatMixHMM contains all the statistics associated to a \link[=ParamMixHMM]{MixHMM}
model, in particular the E-Step of the EM algorithm.
}
\section{Fields}{

\describe{
\item{\code{tau_ik}}{Matrix of size \eqn{(n, K)} giving the posterior probabilities
that the curve \eqn{\boldsymbol{y}_{i}}{y_{i}} originates from the
\eqn{k}-th HMM model.}

\item{\code{gamma_ikjr}}{Array of size \eqn{(nm, R, K)} giving the posterior
probabilities that the observation \eqn{\boldsymbol{y}_{ij}}{y_{ij}}
originates from the \eqn{r}-th regime of the \eqn{k}-th HMM model.}

\item{\code{loglik}}{Numeric. Log-likelihood of the MixHMM model.}

\item{\code{stored_loglik}}{Numeric vector. Stored values of the log-likelihood at
each iteration of the EM algorithm.}

\item{\code{klas}}{Row matrix of the labels issued from \code{tau_ik}. Its elements are
\eqn{klas[i] = z\_i}{klas[i] = z_i}, \eqn{i = 1,\dots,n}.}

\item{\code{z_ik}}{Hard segmentation logical matrix of dimension \eqn{(n, K)}
obtained by the Maximum a posteriori (MAP) rule: \eqn{z\_ik = 1 \
  \textrm{if} \ z\_i = \textrm{arg} \ \textrm{max}_{k} \ P(z_{ik} = 1 |
  \boldsymbol{y}_{i}; \boldsymbol{\Psi}) = tau\_tk;\ 0 \
  \textrm{otherwise}}{z_ik = 1 if z_i = arg max_k P(z_{ik} = 1 | y_{i};
  \Psi) = tau_ik; 0 otherwise}.}

\item{\code{smoothed}}{Matrix of size \eqn{(m, K)} giving the smoothed time series.
The smoothed time series are computed by combining the time series
\eqn{\boldsymbol{y}_{i}}{y_{i}} with both the estimated posterior regime
probabilities \code{gamma_ikjr} and the corresponding estimated posterior
cluster probability \code{tau_ik}. The k-th column gives the estimated mean
series of cluster k.}

\item{\code{BIC}}{Numeric. Value of BIC (Bayesian Information Criterion).}

\item{\code{AIC}}{Numeric. Value of AIC (Akaike Information Criterion).}

\item{\code{ICL1}}{Numeric. Value of ICL (Integrated Completed Likelihood
Criterion).}

\item{\code{log_alpha_k_fyi}}{Private. Only defined for calculations.}

\item{\code{exp_num_trans}}{Private. Only defined for calculations.}

\item{\code{exp_num_trans_from_l}}{Private. Only defined for calculations.}
}}

\section{Methods}{

\describe{
\item{\code{computeStats(paramMixHMM)}}{Method used in the EM algorithm to compute statistics based on
parameters provided by the object \code{paramMixHMM} of class
\link{ParamMixHMM}.}

\item{\code{EStep(paramMixHMM)}}{Method used in the EM algorithm to update statistics based on parameters
provided by the object \code{paramMixHMM} of class \link{ParamMixHMM}
(prior and posterior probabilities).}

\item{\code{MAP()}}{MAP calculates values of the fields \code{z_ik} and \code{klas}
      by applying the Maximum A Posteriori Bayes allocation rule.

      \eqn{z\_ik = 1 \ \textrm{if} \ z\_i = \textrm{arg} \
      \textrm{max}_{k} \ P(z_{ik} = 1 | \boldsymbol{y}_{i};
      \boldsymbol{\Psi}) = tau\_tk;\ 0 \ \textrm{otherwise}}{z_ik = 1 if
      z_i = arg max_k P(z_{ik} = 1 | y_{i};\Psi) = tau_ik; 0 otherwise}.}
}}

\seealso{
\link{ParamMixHMM}
}
