% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dstpFunctions.R, R/zzz_aliases.R
\name{fitMultipleDSTP}
\alias{fitMultipleDSTP}
\alias{fit_multiple_dstp}
\title{Fit the DSTP model to human data with mutiple starting parmaeters}
\usage{
fitMultipleDSTP(
  data,
  conditionName = NULL,
  parms = c(0.145, 0.08, 0.1, 0.07, 0.325, 1.3, 0.24),
  var = 10,
  nParms = 20,
  cdfs = c(0.1, 0.3, 0.5, 0.7, 0.9),
  cafs = c(0.25, 0.5, 0.75),
  maxParms = c(1, 1, 1, 1, 1, 2, 1),
  nTrials = 50000,
  multipleSubjects = TRUE,
  seed = NULL
)

fit_multiple_dstp(
  data,
  conditionName = NULL,
  parms = c(0.145, 0.08, 0.1, 0.07, 0.325, 1.3, 0.24),
  var = 10,
  nParms = 20,
  cdfs = c(0.1, 0.3, 0.5, 0.7, 0.9),
  cafs = c(0.25, 0.5, 0.75),
  maxParms = c(1, 1, 1, 1, 1, 2, 1),
  nTrials = 50000,
  multipleSubjects = TRUE,
  seed = NULL
)

fit_multiple_dstp(
  data,
  conditionName = NULL,
  parms = c(0.145, 0.08, 0.1, 0.07, 0.325, 1.3, 0.24),
  var = 10,
  nParms = 20,
  cdfs = c(0.1, 0.3, 0.5, 0.7, 0.9),
  cafs = c(0.25, 0.5, 0.75),
  maxParms = c(1, 1, 1, 1, 1, 2, 1),
  nTrials = 50000,
  multipleSubjects = TRUE,
  seed = NULL
)
}
\arguments{
\item{data}{A data frame containing human data. See \code{?exampleData} for
data formatted correctly.}

\item{conditionName}{If there is an additional experimental manipulation
(i.e., other than target congruency) the model can only be fit to one at a
time. Tell the function which condition is currently being fit by passing
a string to the function (e.g., "present"). The function by default assumes
no additional condition (e.g., conditionName is set to NULL).}

\item{parms}{A vector of starting parameters to use in the minimisation
routine. Must be in the order: \code{A}, \code{C}, \code{driftTarget},
\code{driftFlanker}, \code{diftStimSelection}, \code{driftRS2}, \code{ter}.
These parameters will be the starting point for the random parameters.}

\item{var}{An integer stating the percentage of each parameter value that
should be used for finding random parameter starting points.}

\item{nParms}{An integer stating how many random starting points to explore}

\item{cdfs}{A vector of quantile values for cumulative distribution functions
to be estimated from the human data. The model will attempt to find the
best-fitting parameters that match this distributional data.}

\item{cafs}{A vector of quantiles for conditional accuracy functions to be
estimated from the human data. The model will attempt to find the best-
fitting parameters that match this distributional data.}

\item{maxParms}{A vector containing upper limits on possible parameter
values.}

\item{nTrials}{An integer stating how many trials to simulate per iteration
of the fitting cycle for each congruency type.}

\item{multipleSubjects}{A boolean stating whether the fit is to multiple
subjects (multipleSubjects = TRUE) or to a single subject
(multipleSubjects = FALSE).}

\item{seed}{The value for the \code{set.seed} function to set random
generation state.}
}
\value{
\code{bestParameters} A vector of the best-fitting parameters found
by the current fit run.

\code{g2} The value of Wilks likelihood ratio (G2) obtained by the
current fit run.

\code{bBIC} The value of the  Bayesian Information Criterion (BIC)
obtained by the current fit run. This is calculated using the BIC equation
for binned data, hence bBIC (binned BIC).
}
\description{
\code{fitMultipleDSTP} fits the DSTP model to a single experimental condition
of human data (besides congruency, which it accounts for simutaneously).
This function explores multiple starting parameters.
}
\details{
This function can be employed by the user to find the best-fitting
parameters of the DSTP model to fit the human data of a single experimental
condition. The fitting procedure accounts for congruent and incongruent
trials simultaneously. The fit is obtained by a gradient-descent method
(using the Nelder-Mead method contained in R's \code{optim} function) and is
fit to the proportion of data contained in human CDF and CAF distributional
data. Multiple starting points of parameters are used.
}
\examples{
# Load the example data the comes with the \code{flankr} package
data(exampleData)

# Fit the model to the condition "present" in the example data set using
# the default settings in the model.
# (Note this is a toy example with very low trial numbers to speed up the
# example. For proper use, increase nTrials.)
\donttest{
fit <- fitMultipleDSTP(data = exampleData, conditionName = "present", nTrials = 100)
}

}
