% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_excel.R
\name{read_excel_folder}
\alias{read_excel_folder}
\title{Import one sheet from each Excel file in a folder}
\usage{
read_excel_folder(
  folder,
  sheetIndex = 1,
  sheetName = NULL,
  allSheets = FALSE,
  define_page = 3,
  page_sep = ":"
)
}
\arguments{
\item{folder}{A string, folder name.}

\item{sheetIndex}{A number, sheet index in the workbook.}

\item{sheetName}{A string, sheet name.}

\item{allSheets}{A boolean.}

\item{define_page}{A integer, 0: no page, 1: file name as page, 2: sheet name
as page, 3: file and sheet names as page, separated by the indicated separator.}

\item{page_sep}{A string, separator to form the page value.}
}
\value{
A \code{pivot_table} object list.
}
\description{
Reads one sheet (or all sheets) from each of the Excel files in a folder and
creates a list of \code{pivot_table} objects, one from each sheet. Each sheet is
expected to contain a pivot table. Each line in a file corresponds to a row
in a table. File and sheet names are included as part of each object
attributes.
}
\details{
When multiple files or sheets are handled, the file and/or sheet names may
contain information associated with the pivot table, they could be the table
page information. In order not to lose this information, they are always
stored in each \code{pivot_table} object.
}
\examples{
folder <- system.file("extdata", "excelfolder", package = "flattabler")
lpt <- read_excel_folder(folder)

lpt <- read_excel_folder(folder, allSheets = TRUE)

}
\seealso{
\code{\link{pivot_table}}

Other import functions: 
\code{\link{read_excel_file}()},
\code{\link{read_excel_sheet}()},
\code{\link{read_text_file}()},
\code{\link{read_text_folder}()}
}
\concept{import functions}
