% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_text.R
\name{read_text_file}
\alias{read_text_file}
\title{Import text file}
\usage{
read_text_file(file, sep = ";", encoding = "UTF-8", define_page = TRUE)
}
\arguments{
\item{file}{A string, name of a text file.}

\item{sep}{Column separator character.}

\item{encoding}{A string, encoding to be assumed for input strings.}

\item{define_page}{A boolean, include file name as \code{pivot_table} page definition.}
}
\value{
A \code{pivot_table} object.
}
\description{
Reads a text file and creates a \code{pivot_table} object. The file is expected to
contain one or more pivot tables. Each line in the file corresponds to a row
in a table; within each row, columns are defined by a separator character.
The file name is included as part of the object attributes.
}
\details{
When multiple files are handled, the file name may contain information
associated with the pivot table, it could be the table page information. In
order not to lose this information, it can be stored in the \code{pivot_table}
object.
}
\examples{

file <- system.file("extdata", "m4.csv", package = "flattabler")
pt <- read_text_file(file)

}
\seealso{
\code{\link{pivot_table}}

Other import functions: 
\code{\link{read_excel_file}()},
\code{\link{read_excel_folder}()},
\code{\link{read_excel_sheet}()},
\code{\link{read_text_folder}()}
}
\concept{import functions}
