% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/encode_sf.R
\name{encode_sf}
\alias{encode_sf}
\title{Wrapper function for encoding simple features}
\usage{
encode_sf(
  geom,
  precision = 5,
  third_dim = NULL,
  third_dim_precision = precision
)
}
\arguments{
\item{geom}{simple feature, \code{sf}, \code{sfc} or \code{sfg} object with geometry type \code{"POINT"}, \code{"LINESTRING"} or \code{"POLYGON"}.}

\item{precision}{integer, precision to use in encoding (between 0 and 15, \code{default=5}).}

\item{third_dim}{integer, type of the third dimension (0: ABSENT, 1: LEVEL, 2: ALTITUDE, 3: ELEVATION, 4, 6: CUSTOM1, 7: CUSTOM2, \code{default=NULL}).}

\item{third_dim_precision}{integer, precision to use in encoding for the third dimension (between 1 and 15, \code{default=precision}).}
}
\value{
The line as string in the flexible polyline encoding format.
}
\description{
A wrapper function for \code{\link{encode}} that converts simple feature geometries
of the sf package to flexible polyline encoded strings.
}
\examples{
# 3D point
point3d <- sf::st_point(
  matrix(c(8.69821, 50.10228, 10), ncol = 3, byrow = TRUE),
  dim = "XYZ"
)
encode_sf(point3d)

# 2D linestring
line2d <- sf::st_linestring(
  matrix(c(
    8.69821, 50.10228,
    8.69567, 50.10201,
    8.68752, 50.09878
  ), ncol = 2, byrow = TRUE)
)
encode_sf(line2d)

# 3D polygon
poly3d <- sf::st_polygon(list(
  matrix(c(
    8.69821, 50.10228, 10,
    8.69567, 50.10201, 20,
    8.69150, 50.10063, 30,
    8.69821, 50.10228, 10
  ), ncol = 3, byrow = TRUE)
), dim = "XYM")
encode_sf(poly3d)
}
