% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auxiliary.R
\name{blockPermute}
\alias{blockPermute}
\title{p-value Computation for Test of Exchangeability with Block Dependencies}
\usage{
blockPermute(X, block_boundaries = NULL, block_labels = NULL, nruns, type, p)
}
\arguments{
\item{X}{The binary or real matrix on which to perform
permutation resampling}

\item{block_boundaries}{Vector denoting the positions where a new
block of non-independent features starts. Default is NULL.}

\item{block_labels}{Length \eqn{P} vector recording the block label of each feature.
Default is NULL.}

\item{nruns}{The resampling number (use at least 1000)}

\item{type}{Either an unbiased estimate ('unbiased'), or exact ('valid') p-value (see Hemerik and Goeman, 2018), or both ('both').}

\item{p}{The power p of \eqn{l_p^p}, i.e., \eqn{||x||_p^p = (x_1^p+...x_n^p)}}
}
\value{
The block permutation p-value
}
\description{
Generates a block permutation p-value. Uses a heuristic to
decide whether to use distance caching or simple block permutations.
}
\details{
Dependencies: buildForward, buildReverse, cachePermute,
cacheBlockPermute1, cacheBlockPermute2, getHammingDistance,
getLpDistance, naiveBlockPermute1, naiveBlockPermute2
}
