% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bind_interactive_svg_data.R
\name{bind_interactive_svg_data}
\alias{bind_interactive_svg_data}
\title{Bind interactive svg data}
\usage{
bind_interactive_svg_data(
  .,
  data = NULL,
  id = NULL,
  reveal_id = NULL,
  h3 = NULL,
  h4 = NULL,
  content = NULL,
  link = NULL,
  metadata = NULL
)
}
\arguments{
\item{.}{The prior Flourish object. No need to specify name if piping graph as the graph will take the first argument (i.e. the prior existing graph).}

\item{data}{Data.}

\item{id}{ID. A column of IDs of elements in the uploaded SVG file. Flourish type hint: column}

\item{reveal_id}{Reveal layer. A column to reveal when layer is clicked. Flourish type hint: column}

\item{h3}{Heading 1. A column containing the main header. Flourish type hint: column}

\item{h4}{Heading 2. A column containing a secondary header. Flourish type hint: column}

\item{content}{Content. A column containing text or HTML to display. Flourish type hint: column}

\item{link}{Link. A URL that can be opened when a layer is clicked. Any reveal layers or popups will be overridden. Flourish type hint: column}

\item{metadata}{Info for popups. One or more columns of information (text, image URLs, embedded charts etc) to include in custom  popups and panels Flourish type hint: columns}
}
\value{
A Flourish chart
}
\description{
Bind interactive svg data
}
\examples{
try(
  flourish(chart_type = "interactive_svg", api_key = Sys.getenv("FLOURISH_API_KEY")) |>
  bind_interactive_svg_data(gapminder)
)
}
