% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/faststress.R
\name{faststress}
\alias{faststress}
\title{Fast Stress Function}
\usage{
faststress(
  lower = NULL,
  delta = NULL,
  data = NULL,
  w = NULL,
  z = NULL,
  d = NULL
)
}
\arguments{
\item{lower}{an n x (n - 1 ) / 2 vector containing lower triangular part of dissimilarity matrix.}

\item{delta}{an n by n square hollow matrix containing dissimilarities.}

\item{data}{an n by m multivariate data matrix.}

\item{w}{an identical sized matrix containing non-negative weights (all ones when omitted).}

\item{z}{n by p matrix with coordinates.}

\item{d}{distances between the rows of z, an n by n square hollow matrix containing Euclidean distances.}
}
\value{
n.stress normalized stress value
}
\description{
\code{faststress} calculates value for normalized stress with different input parameters.
Distances d are optimally scaled.
}
\author{
Frank M.T.A. Busing
}
