% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.fmds.R
\name{predict.fmds}
\alias{predict.fmds}
\title{Predict method for all fmds objects}
\usage{
\method{predict}{fmds}(
  object,
  delta,
  w = NULL,
  level = c("absolute", "ratio", "linear", "ordinal"),
  MAXITER = 1024,
  FCRIT = 1e-08,
  error.check = FALSE,
  echo = FALSE,
  ...
)
}
\arguments{
\item{object}{object of class \code{fmds}.}

\item{delta}{an n by n squares hollow matrix containing dissimilarities.}

\item{w}{an identical sized matrix containing non-negative weights (all ones when omitted).}

\item{level}{parameter indicating whether absolute, ratio, linear, or ordinal level to be used.}

\item{MAXITER}{maximum number of iterations (default = 1024).}

\item{FCRIT}{relative convergence criterion function value (default = 0.00000001).}

\item{error.check}{extensive validity check input parameters (default = FALSE).}

\item{echo}{print intermediate algorithm results (default = FALSE).}

\item{\dots}{additional arguments to be passed.}
}
\value{
data original n by n matrix with dissimilarities.

weights original n by n matrix with weights.

transformed.data final n by n matrix with transformed dissimilarities.

approach apporach to ties: 1 = untie ties, 2 = keep ties tied.

degree spline degree.

ninner number of interior knots.

iknots interior knots sequence.

anchor whether an intervept was used or not.

knotstype type of procedure creating the interior knot sequence.

coordinates final n by p matrix with coordinates.

coefficients final h by p matrix with regression coefficients.

distances final n by n matrix with Euclidean distances between n rows of coordinates.

last.iteration final iteration number.

last.difference final function difference used for convergence testing.

n.stress final normalized stress value.
}
\description{
\code{predict} provides locations for additional objects.
Function is under construction.
}
\author{
Frank M.T.A. Busing
}
