% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ultrafastmdu.R
\name{ultrafastmdu}
\alias{ultrafastmdu}
\title{Ultra Fast Multidimensional Unfolding Function}
\usage{
ultrafastmdu(
  data,
  x,
  y,
  w = NULL,
  fx = NULL,
  fy = NULL,
  NSTEPS = 4096,
  RCRIT = 1e-08,
  seed = runif(1, 1, as.integer(.Machine$integer.max))
)
}
\arguments{
\item{data}{an n by m dissimilarity matrix}

\item{x}{an n by p (p < m) initial row coordinates matrix (required).}

\item{y}{an m by p (p < m) initial column coordinates matrix (required).}

\item{w}{(optional) an n by m weights matrix}

\item{fx}{(optional) an n by p (p < m) fixed row coordinates indicator matrix (0=free;1=fixed) (optional).}

\item{fy}{(optional) an m by p (p < m) fixed column coordinates indicator matrix (0=free;1=fixed) (optional).}

\item{NSTEPS}{(optional) minimum number of learning rate steps (default = 4096).}

\item{RCRIT}{(optional) relative convergence criterion, i.e., lowest learning rate (default = 0.00000001).}

\item{seed}{(optional) seed passed to the C functions.}
}
\value{
x final n by p matrix with row coordinates.

y final m by p matrix with column coordinates.
}
\description{
\code{ultrafastmds} performs simple (weighted) metric multidimensional unfolding.
The function follows algorithms given de Leeuw (1977), Agrafiotis (2003), Rajawat and Kumar (2017), and Busing (submitted).
The memory footprint is delta, x, and y, and w, fixed x and fixed y if present, all provided as input parameter.
}
\examples{
\dontrun{
library(fmdu)

n <- 1000
m <- 10
data <- matrix( runif( n * m ), n, m )
p <- 2
x <- matrix( rnorm( n * p ), n, p )
y <- matrix( rnorm( m * p ), m, p )
r <- ultrafastmdu( data, x, y )
}

}
\references{
de Leeuw (1977).
            Application of convex analysis to multidimensional scaling.
            Recent developments in statistics, pp. 133-145, North-Holland.

            Agrafiotis, D.K. (2003). Stochastic Proximity Embedding.
            Journal of computational chemistry, volume 24, number 10, pages 1215-1221. Wiley Online Library.

            Rajawat, K. and Kumar, S. (2017). Stochastic Multidimensional Scaling.
            IEEE Transactions on Signal and Information Processing over Networks, Vol. 3, No. 2, June 2017.

            Busing (submitted). Node Localization by Multidimensional Scaling with Iterative Majorization:
            An Overview of a Comprehensive Algorithm.
}
