% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fmx_diagnosis.R
\name{fmx_diagnosis}
\alias{fmx_diagnosis}
\alias{Kolmogorov_fmx}
\alias{KullbackLeibler_fmx}
\alias{CramerVonMises_fmx}
\title{Diagnoses for \linkS4class{fmx} Estimates}
\usage{
Kolmogorov_fmx(object, data = object@data, ...)

KullbackLeibler_fmx(object, data = object@data, ...)

CramerVonMises_fmx(object, data = object@data, ...)
}
\arguments{
\item{object}{\linkS4class{fmx} object, or an R object convertible to an \linkS4class{fmx} object}

\item{data}{\link[base]{double} \link[base]{vector}, observed data.
Default is \code{object@data}, the data used for estimation.}

\item{...}{additional parameters, currently not in use}
}
\value{
Functions \code{\link[=Kolmogorov_fmx]{Kolmogorov_fmx()}}, \code{\link[=KullbackLeibler_fmx]{KullbackLeibler_fmx()}}, \code{\link[=CramerVonMises_fmx]{CramerVonMises_fmx()}}
all return \link[base]{numeric} scalars.
}
\description{
Diagnoses for \linkS4class{fmx} estimates.
}
\details{
Function \code{\link[=Kolmogorov_fmx]{Kolmogorov_fmx()}} calculates Kolmogorov distance.

Function \link{KullbackLeibler_fmx} calculates Kullback-Leibler divergence.
The R code is adapted from \code{LaplacesDemon::KLD}.

Function \link{CramerVonMises_fmx} calculates Cramer-von Mises quadratic distance
(via \link[goftest]{cvm.test}).
}
\seealso{
\code{dgof::cvmf.test}
}
\keyword{internal}
