% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{findroot}
\alias{findroot}
\alias{findroot_bisect}
\alias{findroot_brent}
\title{Find Root}
\usage{
findroot_bisect(f, lower, upper, args)

findroot_brent(f, lower, upper, args)
}
\arguments{
\item{f}{Function for which a root is desired.}

\item{lower}{Lower limit of search interval. Must be finite.}

\item{upper}{Upper limit of search interval. Must be finite.}

\item{args}{List of additional arguments from the function \code{findroot_args}.}
}
\value{
A list with the form of a \code{findroot_result} described in section
"Root-Finding" of the package vignette.
}
\description{
Find Root
}
\examples{
f = function(x) { x^2 - 1 }
args = findroot_args()
findroot_bisect(f, 0, 10, args)
findroot_brent(f, 0, 10, args)

}
