% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/form.R
\name{form_validation}
\alias{form_validation}
\title{Form Validation for Fomantic UI}
\usage{
form_validation(
  id,
  ...,
  submit_label = "Submit",
  submit_class = "",
  include_button = TRUE,
  inline = FALSE
)
}
\arguments{
\item{id}{ID of the parent form}

\item{...}{A series of \code{\link{field_validation}} whose \code{id} are inputs contained within the form}

\item{submit_label}{Label to give the submission button at the end of the form (included in returned UI with input
value \code{\{id\}_submit})}

\item{submit_class}{Additional classes to give the submission button}

\item{include_button}{Logical, should the submit button be included? Defaults to \code{TRUE}. If \code{FALSE}, a
\code{\link[shiny.semantic]{action_button}} will be required in the form somewhere with
\code{"submit form-button"} included as part of the class in order for the validation to run.}

\item{inline}{Logical, do you want the field validation errors as in-line labels (\code{TRUE}),
or in a message box at the bottom of the form (\code{FALSE})?}
}
\value{
A \code{shiny.tag.list} containing the inline JS to perform the form validation in the shiny UI.

If \code{include_button = TRUE} then a button will also be included to appear in the UI.
}
\description{
A form validation behaviour checks data against a set of criteria before passing it along to the server.
}
\details{
In order for the validation to work, the \code{form_validation} must be a direct child of the \code{form}.

The "Submit" button has an input value of \code{\{id\}_submit} and will only trigger
server-side events if all the fields pass validation.

\strong{NB} If you do not include either form validation input as part of the server-side code
then the inputs will pass through to the server as if there were no validation.
}
\examples{
if (interactive()) {
  library(shiny)
  library(shiny.semantic)
  library(fomantic.plus)

  ui <- semanticPage(
    tags$head(
      extendShinySemantic()
    ),
    form(
      id = "form",
      field(
        tags$label("Name"),
        text_input("name")
      ),
      field(
        tags$label("E-Mail"),
        text_input("email")
      ),
      form_validation(
        id = "form",
        field_validation("name", field_rule("empty")),
        field_validation("email", field_rule("empty"), field_rule("email"))
      )
    )
  )

  server <- function(input, output) {
  }

  shinyApp(ui, server)
}

}
\references{
\url{https://fomantic-ui.com/behaviors/form.html}
}
\seealso{
\code{\link{field_validation}}, \code{\link{form_button}}
}
