% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_cpr_north_data.R, R/read_cpr_south_data.R,
%   R/read_plankton_nets_data.R, R/read_pump_data.R, R/read_sediment_trap_data.R
\name{read_cpr_north_data}
\alias{read_cpr_north_data}
\alias{read_cpr_south_data}
\alias{read_data}
\alias{read_plankton_nets_data}
\alias{read_pump_data}
\alias{read_sediment_trap_data}
\title{Read FORCIS data}
\usage{
read_cpr_north_data(
  path,
  version = options()$forcis_version,
  check_for_update = options()$forcis_check_for_update
)

read_cpr_south_data(
  path,
  version = options()$forcis_version,
  check_for_update = options()$forcis_check_for_update
)

read_plankton_nets_data(
  path,
  version = options()$forcis_version,
  check_for_update = options()$forcis_check_for_update
)

read_pump_data(
  path,
  version = options()$forcis_version,
  check_for_update = options()$forcis_check_for_update
)

read_sediment_trap_data(
  path,
  version = options()$forcis_version,
  check_for_update = options()$forcis_check_for_update
)
}
\arguments{
\item{path}{a \code{character} of length 1. The folder in which the FORCIS
database has been saved.}

\item{version}{a \code{character} of length 1. The version number (with two
numbers, e.g. \code{08} instead of \code{8}) of the FORCIS database to use.
Default is the latest version. Note that this argument can be handle with
the global option \code{forcis_version}. For example, if user calls
\code{options(forcis_version = "07")}, the version \code{07} will be used by default
for the current R session. Note that it is recommended to use the latest
version of the database.}

\item{check_for_update}{a \code{logical}. If \code{TRUE} (default) the function will
check if a newer version of the FORCIS database is available on Zenodo
and will print an informative message. Note that this argument can be
handle with the global option \code{forcis_check_for_update}. For example, if
user calls \code{options(forcis_check_for_update = FALSE)}, the message to
download the latest version will be disabled for the current R session.}
}
\value{
A \code{tibble}. See
\url{https://zenodo.org/doi/10.5281/zenodo.7390791} for a preview of the
datasets.
}
\description{
These functions read one specific \code{csv} file of the FORCIS database
(see below) stored in the folder \code{path}. The function \code{\link[=download_forcis_db]{download_forcis_db()}}
must be used first to store locally the database.
}
\details{
\itemize{
\item \code{read_plankton_nets_data()} reads the FORCIS plankton nets data
\item \code{read_pump_data()} reads the FORCIS pump data
\item \code{read_cpr_north_data()} reads the FORCIS CPR North data
\item \code{read_cpr_south_data()} reads the FORCIS CPR South data
\item \code{read_sediment_trap_data()} reads the FORCIS sediment traps data
}
}
\examples{
\donttest{
# Folder in which the database will be saved ----
# N.B. In this example we use a temporary folder but you should select an
# existing folder (for instance "data/").
path <- tempdir()

# Download the database ----
download_forcis_db(path, timeout = 300)

# Import plankton nets data ----
plankton_nets_data <- read_plankton_nets_data(path)
}
}
\seealso{
\code{\link[=download_forcis_db]{download_forcis_db()}} to download the complete FORCIS database.
}
