% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bw_datasets.R
\docType{data}
\name{species_bw}
\alias{species_bw}
\title{Phylogenic groupings and trait based clustering of various tree species}
\format{
A data frame with 46 rows and 6 variables:
\describe{
\item{sp}{The code for the species. Link to \code{\link{census_2008_bw}} and \code{\link{census_2014_bw}} with \code{sp} variable.}
\item{genus}{Genus}
\item{species}{Species epithet}
\item{latin}{Scientific name}
\item{family}{Family}
\item{trait_group}{Clustering of species based on three traits rather than
their evolutionary relationships. The traits are specific leaf area, maximum
height, and wood density}
}
}
\source{
For more information on trait clustering see Allen and Kim 2020 "A permutation
test and spatial cross-validation approach to assess models of interspecific competition
between trees." \doi{10.1371/journal.pone.0229930}.
}
\usage{
species_bw
}
\description{
A date frame mapping the species codes to their common names, scientific
names, and families. This also includes a trait-based clustering of the
species.
}
\examples{
library(dplyr)

# Original 2008 census data
census_2008_bw

# 2008 census data with additional species information
census_2008_bw \%>\%
  left_join(species_bw, by = "sp")
}
\seealso{
Other Big Woods data: 
\code{\link{census_2008_bw}},
\code{\link{census_2014_bw}},
\code{\link{study_region_bw}}

Other example data objects: 
\code{\link{blocks_ex}},
\code{\link{census_1_ex}},
\code{\link{census_2008_bw}},
\code{\link{census_2014_bw}},
\code{\link{census_2_ex}},
\code{\link{comp_bayes_lm_ex}},
\code{\link{focal_vs_comp_ex}},
\code{\link{growth_ex}},
\code{\link{growth_spatial_ex}},
\code{\link{growth_toy}},
\code{\link{study_region_bw}},
\code{\link{study_region_ex}}
}
\concept{Big Woods data}
\concept{example data objects}
\keyword{datasets}
