% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{air_meas}
\alias{air_meas}
\title{Air density measurements}
\format{
Classes data.table and data.frame:	5 observations of 7 variables:
\describe{
\item{date}{"Date" class format "YYYY-MM-DD".}
\item{trial}{Character, label "a" through "e".}
\item{humid}{Factor, humidity, "low", "med", or "high."}
\item{temp}{Numeric, measured temperature (K).}
\item{pres}{Numeric, measured atmospheric pressure (Pa).}
\item{sp_gas}{Numeric, specific gas constant in mass form \eqn{R_{sp}},
ideal gas reference value, (J kg\eqn{^{-1}}{^{-1}}K\eqn{^{-1}}{^{-1}}).}
\item{dens}{Numeric, calculated air density
\eqn{\rho} = \eqn{p}\eqn{R_{sp}^{-1}}{^{-1}}\eqn{T^{-1}}{^{-1}}
(kg m\eqn{^{-3}}{^{-3}}).} }
}
\usage{
data(air_meas, package = "formatdown")
}
\description{
Table of air properties at room temperature and pressure, simulating multiple
measurements at approximately steady state,
}
\keyword{datasets}
