% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/format_text.R
\name{format_text}
\alias{format_text}
\title{Format text}
\usage{
format_text(
  x,
  face = "plain",
  ...,
  size = formatdown_options("size"),
  delim = formatdown_options("delim"),
  whitespace = formatdown_options("whitespace")
)
}
\arguments{
\item{x}{Vector to be formatted.}

\item{face}{Font face. Determines the font face macro inside the math
delimiters. Possible values are "plain" (default), "italic", "bold",
"sans", or "mono". One may assign instead the corresponding LaTeX-style
markup itself, e.g., \verb{\\\\mathrm}, \verb{\\\\mathit}, \verb{\\\\mathbf}, \verb{\\\\mathsf}, or
\verb{\\\\mathtt}.}

\item{...}{Not used, force later arguments to be used by name.}

\item{size, delim, whitespace}{Used to format the math-delimited character
strings. For details, see the help page for \code{formatdown_options()}.}
}
\value{
A character vector with elements delimited as inline math markup
in plain, italic, sans serif, bold, or monospace font face.
}
\description{
Convert a character vector to "math text" delimited for rendering as inline
equations in an R markdown document. Particularly useful for matching the
font face of character columns to that of numerical columns in a table.
}
\details{
Given a scalar, vector, or data frame column, \code{format_text()} converts its
argument to a character string of the form \code{"$\\\\mathxx{a}$"} where \code{a}
is the element to be formatted and \verb{\\\\mathxx} determines the font face:
plain type is set by \verb{\\\\mathrm}; italic by \verb{\\\\mathit};
bold by \verb{\\\\mathbf}; sans serif by \verb{\\\\mathsf}; and monospace (typewriter
text) by \verb{\\\\mathtt}. All strings include markup delimiters \verb{$...$} for
rendering (in an R markdown or Quarto markdown document) as an inline
equation.
}
\examples{
# Text vector

# default face = "plain"
x <- air_meas$humid
format_text(x)

# equivalently
format_text(x, face = "plain")

# input vector
x <- c("Hello world!", "Goodbye blues!")
format_text(x)

# argument coerced to character string if possible
format_text(c(1.2, 2.3, 3.4))
format_text(x = NA)
format_text(x = c(TRUE, FALSE, TRUE))

# numbers as strings are rendered as-is
format_text(x = c("1.2E-3", "3.4E+0", "5.6E+3"))

# other font faces
format_text(x, face = "italic")
format_text(x, face = "bold")
format_text(x, face = "sans")
format_text(x, face = "mono")
}
\seealso{
Other format_*: 
\code{\link{format_dcml}()},
\code{\link{format_engr}()},
\code{\link{format_numbers}()},
\code{\link{format_sci}()}
}
\concept{format_*}
