\docType{data}
\name{newdata}
\alias{newdata}
\title{Fixation probability data generated by ft2fp() function}
\format{In the data frame each row represents the fixation probability 
  and other information for one spatio-temporal unit. The data frame has 
  the following columns:
    \describe{
      \item{\code{list}}{the id of the list}
      \item{\code{subject}}{the id of the subject}
      \item{\code{condition}}{the id of the condition}
      \item{\code{region}}{the id of the region}
      \item{\code{Time}}{the time after eyes leave critical region}
      \item{\code{N}}{total number of valid trials}
      \item{\code{y}}{number of trials with fixations}
      \item{\code{fix_prob}}{the fixation probability}}}
\usage{
  data(newdata)
}
\description{
  This data set is the fixation probability data generated by the ft2fp() 
  function. The data set retains the information of list, subject, and
  condition of original fixation time data set. The variable "Time" is
  generated based on the TimeCourse and TimeInterval arguments defined 
  by users. The variable "N" is the total number of valid trials after
  the deletion of invalid ones for the corresponding spatio-temporal 
  unit. The variable "y" is the number of trials with fixations on that 
  particular region at that time point. Fixation probability is calculated
  by dividing y by N. "N" and "y" would be used for further analysis in
  empirical logistic transformation and lme modeling.
}
\keyword{datasets}
