% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/emfrail_methods.R
\name{logLik.emfrail}
\alias{logLik.emfrail}
\title{Log-likelihood for \code{emfrail} fitted models}
\usage{
\method{logLik}{emfrail}(object, ...)
}
\arguments{
\item{object}{An \code{emfrail} object}

\item{...}{Other arguments}
}
\value{
An object of class \code{logLik} containing the marginal log-likelihood of the fitted model
}
\description{
Log-likelihood for \code{emfrail} fitted models
}
\details{
The formula for the likelihood can be found in the manual which accompanies the package. Note that a constant
is added. If we denote \eqn{\bar{n}} the total number of events and \eqn{\bar{n_i}} the total number of events at time point
\eqn{i}, for each time point where events are observed, then this is equal to
\deqn{\bar{n} - \sum_i \bar{n_i} \log \bar{n_i}.}
This is mostly because of compatibility, i.e. to match the log-likelihood given by the \code{survival} package.

The \code{df} attribute of this object is equal to the number of regression coefficents plus 1.
In general, the number of degrees of freedom for a frailty model is an unclear concept. For the \code{coxph} frailty fits,
and in general for the shared frailty models fitted by penalized likelihood, the degrees of freedom is a number
that depends on the penalization. However, even in that case, there is no straight forward interpretation or use of this
quantity. The decision made here is because this would keep the likelihood ratio test for a covariate effect valid.
}
