% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cspline.R
\name{as.data.frame.curve}
\alias{as.data.frame.curve}
\title{Conversion to data frame}
\usage{
\method{as.data.frame}{curve}(x, row.names = NULL, optional = FALSE, ...)
}
\arguments{
\item{x}{An object inheriting from class \code{"curve"}}

\item{row.names, optional, ...}{as for \code{\link[base]{as.data.frame}}.}
}
\value{
A data frame object
}
\description{
Method function to convert an object inheriting from class \code{"curve"}
to a \code{data.frame}
}
\examples{
library(ggplot2)
set.seed(1234)
z <- complex(real = runif(5), imaginary = runif(5))
z <- z[order(Arg(z - mean(z)))]
cz <- closed_curve(z)
oz <- open_curve(z)
ggplot() + geom_path(data = as.data.frame(cz), aes(x,y), colour = "#DF536B") +
    geom_path(data = as.data.frame(oz), aes(x,y), colour = "#2297E6") +
    geom_point(data = as.data.frame(z), aes(x = Re(z), y = Im(z))) +
    geom_segment(data = as.data.frame(z), aes(x = Re(mean(z)),
                                              y = Im(mean(z)),
                                              xend = Re(z),
                                              yend = Im(z)),
                 arrow = arrow(angle=15, length=unit(0.125, "inches")),
                 colour = alpha("grey", 1/2)) +
    theme_bw()

}
