% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grep_file.R
\name{grep_file}
\alias{grep_file}
\title{Grep a Pattern from Files}
\usage{
grep_file(paths, pattern, a = 1, b = 1, ...)
}
\arguments{
\item{paths}{A vector of file paths.}

\item{pattern}{The pattern to grep.}

\item{a}{Number of lines of trailing context before matching lines.
Like \command{grep}'s -A option.}

\item{b}{Number of lines of leading context before matching lines.
Like \command{grep}'s -B option.}

\item{...}{Arguments passed to \code{\link{list.files}}.}
}
\value{
A named list with one item per file path.
Each item consists of a list of row numbers matching the pattern. Each item
is a vector of the matching lines and \bold{b} lines before and \bold{a}
lines after the matching lines.
}
\description{
This is an approximation of the \kbd{unix} command \command{grep}.
}
\examples{
file_paths <- list.files(path = system.file("tinytest",
                                            package = "fritools2"),
                         pattern = ".*\\\\.R", full.names = TRUE)
res <- grep_file(path = file_paths, pattern = "forSureNotThere",
                 a = 3, b = 2, ignore.case = TRUE)
tinytest::expect_true(all(res == FALSE))
}
\seealso{
Other searching functions: 
\code{\link{compare_vectors}()},
\code{\link{file_modified_last}()},
\code{\link{find_files}()},
\code{\link{fromto}()},
\code{\link{missing_docs}},
\code{\link{search_files}()},
\code{\link{search_rows}()},
\code{\link{summary.filesearch}()}

Other file utilities: 
\code{\link{clipboard_path}()},
\code{\link{delete_trailing_blank_lines}()},
\code{\link{delete_trailing_whitespace}()},
\code{\link{develop_test}()},
\code{\link{file_copy}()},
\code{\link{file_modified_last}()},
\code{\link{file_save}()},
\code{\link{find_files}()},
\code{\link{get_lines_between_tags}()},
\code{\link{get_mtime}()},
\code{\link{get_unique_string}()},
\code{\link{is_files_current}()},
\code{\link{is_path}()},
\code{\link{paths}},
\code{\link{search_files}()},
\code{\link{split_code_file}()},
\code{\link{touch}()}
}
\concept{file utilities}
\concept{searching functions}
