% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bioclim_thermal.R
\name{bioclim_thermal}
\alias{bioclim_thermal}
\title{Calculation of bioclimatic viticultural indices focusing on temperature}
\usage{
bioclim_thermal(climdata, lat)
}
\arguments{
\item{climdata}{a dataframe with daily maximum and minimum temperatures.
Must contain the columns Year, Month, Day, Tmax, Tmin.}

\item{lat}{the latitude of the site, in decimal degrees. Use positive values
for Northern latitudes and negatives for Southern.}
}
\value{
data frame with the values of the indices. It contains the columns
Year, CI, GST, BEDD, HI, WI
}
\description{
This function calculates the Growing Season Average Temperature (GST), the
Heliothermal Index (HI) of Huglin, the Winkler (WI) index, the Biologically
Effective Degree Day (BEDD) index and the Cool Night (CI) index.
}
\details{
GST index correlates broadly to the maturity potential for grape cultivars 
grown across many wine regions and provides the basis for zoning viticultural
areas in both hemispheres (Hall and Jones, 2009). It is calculated by taking
the average of the growing season (April-October in Northern hemisphere, October
-April in Southern hemisphere).

HI (Huglin, 1978) is a bioclimatic heat index for viticulture regions using 
heliothermic potential, which calculates the temperature sum above 10ºC from 
April until September (Northern hemisphere) or from October until March (Southern
 hem.). The index takes into consideration daily maximum and average temperature, 
and slightly modifies the calculated total using the latitude of the location.

WI index (Amerine and Winkler, 1944), also known as growing degree days (GDD) 
classifies regions based on the accumulation of heat summation units by adding up 
hours above 10ºC during the growing season.

BEDD index (Gladstones, 1992) is another variant on calculating heat summation 
which incorporates upper and lower temperature thresholds (accounts for heat 
accumulation between 10 and 19ºC) and a day length correction similar to HI.

CI index (Tonietto, 1999) takes into account the minimum temperature during 
grape maturation, which is normally the average minimum air temperature in 
September/March (Northern or Southern hemispheres, respectively).
}
\examples{

# Select the appropiate columns from a larger dataset with date information
# in Year, Month, Day format, and estimate indices on each year in the series.
library(magrittr)
library(dplyr)
Weather <- Tudela_DW \%>\%
   select(Year, Month, Day, Tmax, Tmin)
latitude <- 42.13132
Tudela_BTI <- bioclim_thermal(Weather, latitude)

}
\references{
Amerine MA and Winkler AJ. 1944. Composition and quality of musts and wines
of California grapes. Hilgardia 15: 493-675.

Gladstones J. 1992. Viticulture and environment. Winetitles, Adelaide, Australia 

Hall A., Jones GV. 2009. Effect of potential atmospheric warming on 
temperature-based indices describing Australian winegrape growing conditions.
Aust J Grape Wine Res 15. 97-119.

Huglin P. 1978. Noveau mode d'evaluation des possibilites héliothermiques
d'un milieu viticole. In: Proceedings of the Symposium International sur
l'ecologie de la Vigne. Ministére de l'Agriculture et de l'Industrie 
Alimentaire, Contança pp 89-98.

Tonietto J. 1999. Les macroclimats viticoles mondiaux et l'influence du
mésoclimat sur la typicité de la Syrah et du Muscat de Hambourg dans le
sud de la France: methodologie de carácterisation. Thése Doctorat. Ecole 
Nationale Supérieure Agronomique, Montpellier, 233pp.
}
\author{
Carlos Miranda, \email{carlos.miranda@unavarra.es}
}
