% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/models_lib.R
\name{desc_groups_rank}
\alias{desc_groups_rank}
\title{Profiling categorical variable (rank)}
\usage{
desc_groups_rank(data, group_var, group_func = mean)
}
\arguments{
\item{data}{input data source}

\item{group_var}{variable to make the group by}

\item{group_func}{the data type of this parameter is a function, not an string, this is the function to be used in the group by, the default value is: mean}
}
\value{
grouped data frame, showing the rank instead of the absolute values/
}
\description{
Similar to 'desc_groups' function, this one computes the rank of each value in order to quickly know what is the value in each segment that has the highest value (rank=1). 1 represent the highest number. It will exclude all factor/character variables.
}
\examples{
# default grouping function: mean
desc_groups_rank(data=mtcars, group_var="gear")

# using the median as the grouping function
desc_groups(data=mtcars, group_var="cyl", group_func=median)

# using the max as the grouping function
desc_groups_rank(data=mtcars, group_var="gear", group_func=max)
}
