# WARNING - Generated by {fusen} from dev/flat_package.Rmd: do not edit by hand

test_that("stat_mo", {
    MatX <- matrix(rnorm(100), nrow = 25, ncol = 4)
    MatY <- matrix(rnorm(125), nrow = 25, ncol = 5) + 10
    
    checkmate::qexpect(stat_mo(MatX, MatY), "N1[0,)")
    
    expect_true(stat_mo(MatX, MatX) < stat_mo(MatX, MatY))
})

test_that("stat_med", {
    MatX <- matrix(rnorm(100), nrow = 25, ncol = 4)
    MatY <- matrix(rnorm(125), nrow = 25, ncol = 5) + 10
    
    checkmate::qexpect(stat_med(MatX, MatY), "N1[0,)")
    
    expect_true(stat_med(MatX, MatX) < stat_med(MatX, MatY))
})

test_that("stat_wmw", {
    MatX <- matrix(rnorm(100), nrow = 25, ncol = 4)
    MatY <- matrix(rnorm(125), nrow = 25, ncol = 5) + 10
    
    checkmate::qexpect(stat_wmw(MatX, MatY), "N1[0,)")
    
    expect_true(stat_wmw(MatX, MatX) < stat_wmw(MatX, MatY))
})

test_that("stat_hkr", {
    MatX <- matrix(rnorm(100), nrow = 25, ncol = 4)
    MatY <- matrix(rnorm(125), nrow = 25, ncol = 5) + 10
    
    res1 <- stat_hkr(MatX, MatY)
    
    checkmate::expect_list(res1, len = 3)
    expect_equal(names(res1), c("T1", "T2", "eigenval"))
    checkmate::qexpect(res1$T1, "N1[0,)")
    checkmate::qexpect(res1$T2, "N1[0,)")
    checkmate::qexpect(res1$eigenval, "N+[0,)")
    
    res2 <- stat_hkr(MatX, MatX)
    
    expect_true(res2$T1 < res1$T1)
    expect_true(res2$T2 < res1$T2)
})

test_that("stat_cff", {
    MatX <- matrix(rnorm(100), nrow = 25, ncol = 4)
    MatY <- matrix(rnorm(125), nrow = 25, ncol = 5) + 10
    
    checkmate::qexpect(stat_cff(MatX, MatY), "N1[0,)")
    
    expect_true(stat_cff(MatX, MatX) < stat_cff(MatX, MatY))
})

test_that("comp_stat", {
    MatX <- matrix(rnorm(100), nrow = 25, ncol = 4)
    MatY <- matrix(rnorm(125), nrow = 25, ncol = 5) + 10
    
    stat <- "mo"
    res <- comp_stat(MatX, MatY, stat)
    checkmate::check_list(res, len = 1)
    expect_equal(names(res), stat)
    checkmate::qexpect(res[[1]], "N1[0,)")
    
    stat <- "hkr"
    res <- comp_stat(MatX, MatY, stat)
    checkmate::check_list(res, len = 1)
    expect_equal(names(res), stat)
    checkmate::qexpect(res[[1]], "N2[0,)")
    
    stat <- c("mo", "med", "wmw", "hkr", "cff")
    res <- comp_stat(MatX, MatY, stat)
    checkmate::check_list(res, len = length(stat))
    expect_equal(names(res), stat)
    checkmate::qexpect(res[[1]], "N1[0,)")
    expect_equal(res[[1]], stat_mo(MatX, MatY))
    checkmate::qexpect(res[[2]], "N1[0,)")
    expect_equal(res[[2]], stat_med(MatX, MatY))
    checkmate::qexpect(res[[3]], "N1[0,)")
    expect_equal(res[[3]], stat_wmw(MatX, MatY))
    checkmate::qexpect(res[[4]], "N2[0,)")
    expect_equal(res[[4]], as.matrix(unlist(stat_hkr(MatX, MatY)[1:2])))
    checkmate::qexpect(res[[5]], "N1[0,)")
    expect_equal(res[[5]], stat_cff(MatX, MatY))
})
