% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/verify_column_info.R
\name{verify_column_info}
\alias{verify_column_info}
\title{Verify the integrity of the column info object}
\usage{
verify_column_info(column_info, data)
}
\arguments{
\item{column_info}{A data frame describing which columns in \code{data} to
plot. This data frame should contain the following columns:
\itemize{
\item \code{id} (\code{character}, required): A column name in \code{data} to plot. Determines the
size of the resulting geoms, and also the color unless \code{color} is
specified.
\item \code{id_color} (\code{character}): A column name in \code{data} to use for the color
of the resulting geoms. If \code{NA}, the \code{id} column will be used.
\item \code{id_size} (\code{character}): A column name in \code{data} to use for the size
of the resulting geoms. If \code{NA}, the \code{id} column will be used.
\item \code{name} (\code{character}): A label for the column. If \code{NA} or \code{""},
no label will be plotted. If this column is missing, \code{id} will
be used to generate the \code{name} column.
\item \code{geom} (\code{character}): The geom of the column. Must be one of:
\code{"funkyrect"}, \code{"circle"}, \code{"rect"}, \code{"bar"}, \code{"pie"}, \code{"text"} or \code{"image"}.
For \code{"text"}, the corresponding column in \code{data} must be a \code{character}.
For \code{"pie"}, the column must be a list of named numeric vectors.
For all other geoms, the column must be a \code{numeric}.
\item \code{group} (\code{character}): The grouping id of each column, must match with
\code{column_groups$group}. If this column is missing or all values are \code{NA},
columns are assumed not to be grouped.
\item \code{palette} (\code{character}): Which palette to colour the geom by.
Each value should have a matching value in \code{palettes$palette}.
\item \code{width}: Custom width for this column (default: 1).
\item \code{overlay}: Whether to overlay this column over the previous column.
If so, the width of that column will be inherited.
\item \code{legend}: Whether or not to add a legend for this column.
\item \code{hjust}: Horizontal alignment of the bar, must be between [0,1]
(only for \code{geom = "bar"}).
\item \code{vjust}: Vertical alignment of the label, must be between [0,1]
(only for \code{geom = "text"}).
\item \code{size}: Size of the label, must be a numeric value
(only for \code{geom = "text"}).
\item \code{label}: Which column to use as a label (only for \code{geom = "text"}).
\item \code{directory}: Which directory to use to find the images (only for \code{geom = "image"}).
\item \code{extension}: The extension of the images (only for \code{geom = "image"}).
\item \code{draw_outline}: Whether or not to draw bounding guides (only for \code{geom == "bar"}).
Default: \code{TRUE}.
\item \code{options} (\code{list} or \code{json}): Any of the options above. Any values in this
column will be spread across the other columns. This is useful for
not having to provide a data frame with 1000s of columns.
This column can be a json string.
}}

\item{data}{A data frame with items by row and features in the columns.
Must contain one column named \code{"id"}.}
}
\value{
The column info object with all expected columns.
}
\description{
Verify the integrity of the column info object
}
\examples{
library(tibble)
data <- tribble(
  ~id, ~name, ~x, ~y,
  "foo", "Foo", 0.5, 0.7,
  "bar", "Bar", 1.0, 0.1
)
column_info <- tribble(
  ~id, ~geom,
  "name", "text",
  "x", "funkyrect",
  "y", "funkyrect"
)
verify_column_info(column_info, data)
}
