% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/proxy.R
\name{g6_update_nodes}
\alias{g6_update_nodes}
\alias{g6_update_edges}
\alias{g6_update_combos}
\title{Update nodes/edges/combos to a g6 graph via proxy}
\usage{
g6_update_nodes(graph, nodes)

g6_update_edges(graph, edges)

g6_update_combos(graph, combos)
}
\arguments{
\item{graph}{A g6_proxy object created with \code{\link{g6_proxy}}.}

\item{nodes, edges, combos}{A data frame or list specifying
the nodes/edges/combos to be updated. All elements have to be of the same type,
you can't mix nodes with edges.}
}
\value{
The g6_proxy object (invisibly), allowing for method chaining.
}
\description{
This function updates one or more nodes/edges/combos to an existing g6 graph instance
using a proxy object. This allows updating the graph without completely
re-rendering it.
}
\details{
This function can only be used with a g6_proxy object within a Shiny application.
It will not work with regular g6 objects outside of Shiny.

See \url{https://g6.antv.antgroup.com/en/api/data#graphupdatenodedata},
\url{https://g6.antv.antgroup.com/en/api/data#graphupdateedgedata} and
\url{https://g6.antv.antgroup.com/en/api/data#graphupdatecombodata} for more details.
}
\seealso{
\code{\link{g6_proxy}}, \code{\link{g6_remove_nodes}}
}
