/*
 * Decompiled with CFR 0.152.
 */
package org.af.gMCP.gui.dialogs;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileFilter;
import org.af.commons.tools.OSTools;
import org.af.gMCP.config.Configuration;
import org.af.gMCP.gui.CreateGraphGUI;
import org.af.gMCP.gui.dialogs.ImagePanel;
import org.af.gMCP.gui.graph.GraphView;
import org.af.gMCP.gui.graph.Node;
import org.mutoss.gui.TransferableImage;

public class ImageExportDialog
extends JDialog
implements ActionListener,
ChangeListener {
    JButton ok = new JButton("Save file");
    JTextField tfFile = new JTextField();
    JCheckBox cbColored = new JCheckBox();
    JCheckBox cbTransparent = new JCheckBox();
    JButton selectFile = new JButton("Choose file:");
    ImagePanel ip;
    JSpinner spinnerRadius;
    JCheckBox markEpsilon;
    JCheckBox drawHypNames = new JCheckBox("Draw names of hypotheses");
    JCheckBox drawHypWeights = new JCheckBox("Draw weights of hypotheses");
    JCheckBox drawEdgeWeights = new JCheckBox("Draw weights of edges");
    JButton copyToClipboard = new JButton("Copy to clipboard");
    CreateGraphGUI parent;
    GraphView control;

    public ImageExportDialog(CreateGraphGUI parent, boolean saveToFile) {
        super(parent, "Export Image", true);
        this.setLocationRelativeTo(parent);
        this.parent = parent;
        this.control = parent.getGraphView();
        String cols = "5dlu, pref, 5dlu, fill:pref:grow, 5dlu, pref, 5dlu";
        String rows = "5dlu, fill:pref:grow, 5dlu, pref, 5dlu";
        if (saveToFile) {
            rows = rows + ", pref, 5dlu";
        }
        FormLayout layout = new FormLayout(cols, rows);
        this.getContentPane().setLayout((LayoutManager)layout);
        CellConstraints cc = new CellConstraints();
        int row = 2;
        this.getContentPane().add((Component)this.getOptionsPanel(), cc.xy(6, row));
        this.ip = new ImagePanel(this.getImage(), 0, 0, 50, 50);
        this.getContentPane().add((Component)this.ip, cc.xyw(2, row, 3));
        row += 2;
        if (saveToFile) {
            this.selectFile.addActionListener(this);
            this.tfFile.setText(Configuration.getInstance().getClassProperty(this.getClass(), "LastImage", ""));
            this.getContentPane().add((Component)this.selectFile, cc.xy(2, row));
            this.getContentPane().add((Component)this.tfFile, cc.xyw(4, row, 3));
            this.getContentPane().add((Component)this.ok, cc.xy(6, row += 2));
            this.ok.addActionListener(this);
        } else {
            this.getContentPane().add((Component)this.copyToClipboard, cc.xy(6, row));
            this.copyToClipboard.addActionListener(this);
        }
        this.pack();
        this.setVisible(true);
    }

    public JPanel getOptionsPanel() {
        JPanel panel = new JPanel();
        String cols = "5dlu, pref, 5dlu, fill:pref:grow, 5dlu, pref, 5dlu";
        String rows = "5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu";
        FormLayout layout = new FormLayout(cols, rows);
        panel.setLayout((LayoutManager)layout);
        CellConstraints cc = new CellConstraints();
        int row = 2;
        this.cbColored = new JCheckBox("Colored graph");
        this.cbColored.addActionListener(this);
        this.cbColored.setSelected(Configuration.getInstance().getGeneralConfig().getColoredImages());
        panel.add((Component)this.cbColored, cc.xyw(2, row, 3));
        this.cbTransparent = new JCheckBox("Transparent background (recommended)");
        this.cbTransparent.addActionListener(this);
        this.cbTransparent.setSelected(Configuration.getInstance().getGeneralConfig().exportTransparent());
        panel.add((Component)this.cbTransparent, cc.xyw(2, row += 2, 3));
        row += 2;
        this.markEpsilon = new JCheckBox("Show epsilon edges as dashed lines.");
        this.markEpsilon.setSelected(Configuration.getInstance().getGeneralConfig().markEpsilon());
        this.markEpsilon.setToolTipText("<html>You can set whether epsilon edges should<br>been shown as dashed or solid lines.</html>");
        this.drawHypNames.addActionListener(this);
        this.drawHypNames.setSelected(Configuration.getInstance().getGeneralConfig().exportTransparent());
        panel.add((Component)this.drawHypNames, cc.xyw(2, row += 2, 3));
        this.drawHypWeights.addActionListener(this);
        this.drawHypWeights.setSelected(Configuration.getInstance().getGeneralConfig().exportTransparent());
        panel.add((Component)this.drawHypWeights, cc.xyw(2, row += 2, 3));
        this.drawEdgeWeights.addActionListener(this);
        this.drawEdgeWeights.setSelected(Configuration.getInstance().getGeneralConfig().exportTransparent());
        panel.add((Component)this.drawEdgeWeights, cc.xyw(2, row += 2, 3));
        this.spinnerRadius = new JSpinner(new SpinnerNumberModel(Node.getRadius(), 2, 1000, 1));
        this.spinnerRadius.addChangeListener(this);
        panel.add((Component)new JLabel("Node radius"), cc.xy(2, row += 2));
        panel.add((Component)this.spinnerRadius, cc.xyw(4, row, 3));
        return panel;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.ok) {
            int answer;
            File f = new File(this.tfFile.getText());
            if (f.exists() && (answer = JOptionPane.showConfirmDialog(this, "File exists. Overwrite file?", "File exists", 0, 2)) == 1) {
                return;
            }
            if (f.isDirectory()) {
                JOptionPane.showMessageDialog(this, "You only specified a directory.\nPlease enter also a file name for saving the image.", "Can not save file", 0);
                return;
            }
            if (f.getParentFile() == null || !f.getParentFile().exists()) {
                JOptionPane.showMessageDialog(this, "You either did not specify a file or the specified parent directory does not exist.\nPlease choose another file for saving the image.", "Can not save file", 0);
                return;
            }
            this.control.saveGraphImage(f, this.drawHypNames.isSelected(), this.drawHypWeights.isSelected(), this.drawEdgeWeights.isSelected());
            this.parent.getMBar().showFile(f);
            this.dispose();
        } else if (e.getSource() == this.copyToClipboard) {
            String jsv;
            if (OSTools.isLinux() && !Configuration.getInstance().getClassProperty(this.getClass(), "showClipboardInfo", "yes").equals("no") && ((jsv = System.getProperty("java.specification.version")).equals("1.5") || jsv.equals("1.6"))) {
                String message = "An old bug from 2007 that is widely known but never\nfixed by Sun/Oracle in Java will most likely prevent this\nfeature to work on a Linux machine.\nWe are sorry\u2026";
                JCheckBox tellMeAgain = new JCheckBox("Don't show me this info again.");
                JOptionPane.showMessageDialog(this.parent, new Object[]{message, tellMeAgain}, "Will most likely not work under Linux", 2);
                if (tellMeAgain.isSelected()) {
                    Configuration.getInstance().setClassProperty(this.getClass(), "showClipboardInfo", "no");
                }
            }
            TransferableImage.copyImageToClipboard(this.control.getNL().getImage(Configuration.getInstance().getGeneralConfig().getExportZoom(), Configuration.getInstance().getGeneralConfig().getColoredImages(), this.drawHypNames.isSelected(), this.drawHypWeights.isSelected(), this.drawEdgeWeights.isSelected()));
            this.dispose();
        } else if (e.getSource() == this.cbColored) {
            Configuration.getInstance().getGeneralConfig().setColoredImages(this.cbColored.isSelected());
        } else if (e.getSource() == this.cbTransparent) {
            Configuration.getInstance().getGeneralConfig().setExportTransparent(this.cbTransparent.isSelected());
        } else if (e.getSource() == this.selectFile) {
            JFileChooser fc = new JFileChooser(Configuration.getInstance().getClassProperty(this.getClass(), "ImageDirectory"));
            fc.setFileSelectionMode(0);
            fc.setDialogType(1);
            fc.setFileFilter(new FileFilter(){

                @Override
                public boolean accept(File f) {
                    if (f.isDirectory()) {
                        return true;
                    }
                    return f.getName().toLowerCase().endsWith(".png");
                }

                @Override
                public String getDescription() {
                    return "PNG image files";
                }
            });
            int returnVal = fc.showOpenDialog(this);
            if (returnVal == 0) {
                File f = fc.getSelectedFile();
                Configuration.getInstance().setClassProperty(this.getClass(), "ImageDirectory", f.getParent());
                if (!f.getName().toLowerCase().endsWith(".png")) {
                    f = new File(f.getAbsolutePath() + ".png");
                }
                this.tfFile.setText(f.getAbsolutePath());
                Configuration.getInstance().setClassProperty(this.getClass(), "LastImage", f.getAbsolutePath());
            }
        }
        this.ip.setImage(this.getImage());
        this.repaint();
    }

    public BufferedImage getImage() {
        return this.control.getNL().getImage(1.0, Configuration.getInstance().getGeneralConfig().getColoredImages(), this.drawHypNames.isSelected(), this.drawHypWeights.isSelected(), this.drawEdgeWeights.isSelected());
    }

    public void save() {
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.control.getNL().setRadius(Integer.parseInt(this.spinnerRadius.getModel().getValue().toString()));
        this.ip.setImage(this.getImage());
        this.repaint();
        this.parent.repaint();
    }
}

