% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gasfluxes-package.R
\docType{package}
\name{gasfluxes-package}
\alias{gasfluxes-package}
\title{Calculate greenhouse gas flux calculation from chamber measurements.}
\description{
Gasfluxes provides functions for fitting non-linear concentration - time models as well as convenience functions
for checking data and combining different calculation methods.
}
\details{
The wrapper function for convenient flux calculation is
\code{\link{gasfluxes}}. Several concentration - time models are implemented
\itemize{
\item \code{\link{HMR.fit}}: An implementation of HMR using partially linear least-squares.
\item \code{\link{NDFE.fit}}: An implementation of the NDFE model using partially linear least-squares.
\item \code{\link{lin.fit}}: A simple linear model.
\item \code{\link{rlin.fit}}: A simple linear model fit using robust regression.
}
}
\seealso{
Useful links:
\itemize{
  \item \url{https://git-dmz.thuenen.de/fuss/gasfluxes}
}

}
\author{
\strong{Maintainer}: Roland Fuss \email{roland.fuss@thuenen.de} (\href{https://orcid.org/0000-0002-0274-0809}{ORCID})

Other contributors:
\itemize{
  \item Roman Hueppi (\href{https://orcid.org/0000-0001-8815-7835}{ORCID}) [contributor]
}

}
\keyword{internal}
