% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eigensort.R
\name{eigensort}
\alias{eigensort}
\title{Spectral Decomposition of a Symmetric Matrix}
\usage{
eigensort(M)
}
\arguments{
\item{M}{Symmetric matrix, either sparse or dense, to be decomposed.}
}
\value{
A list containing:
\itemize{
  \item \code{evalues}: A vector of sorted eigenvalues in increasing order.
  \item \code{evectors}: A matrix of corresponding eigenvectors.
}
}
\description{
\code{eigensort} performs the spectral decomposition of a symmetric matrix. The eigenvalues and eigenvectors are sorted in increasing order by eigenvalues.
}
\examples{
A <- matrix(1, ncol=2, nrow=2)
dec <- eigensort(A)
}
