% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gators_merge.R
\name{gators_merge}
\alias{gators_merge}
\title{Merge Retained Data - Combined original data set with georeferenced or retained records.}
\usage{
gators_merge(df1, df2)
}
\arguments{
\item{df1}{A data frame downloaded with \code{gators_download()} and prepared using \code{remove_missing()}.}

\item{df2}{A data frame with the same columns as df1, but with observations generated through georeferencing or through data requests.}
}
\value{
A combined data set.
}
\description{
The \code{gators_merge()} function combines two data sets with identical column names and returns a single data set.
}
\details{
Prior to combining a data set with georeferenced or retrieved data, please use the \code{remove_missing()} function to limit duplicate records. This function requires no additional packages.
}
\examples{
removed_missing <- remove_missing(data)
needs_geo <- need_to_georeference(data)
# fill in manually georeferenced data into needs_geo...
merged_data <- gators_merge(removed_missing, needs_geo)
needs_data <- needed_records(data)
# fill in missing information with a data request...
merged_data <- gators_merge(merged_data, needs_data)

}
