% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_SEIQRDP.R
\name{fit_SEIQRDP}
\alias{fit_SEIQRDP}
\title{Fit SEIQRDP function}
\usage{
fit_SEIQRDP(
  Q,
  R,
  D,
  Npop,
  E0,
  I0,
  time,
  alpha = 0.05,
  dt = 1/24,
  guess,
  ftol = sqrt(.Machine$double.eps),
  ptol = sqrt(.Machine$double.eps),
  gtol = 0,
  diag = list(),
  epsfcn = 0,
  factor = 100,
  maxfev = integer(),
  maxiter = 1000,
  nprint = 1,
  trace = TRUE,
  ...
)
}
\arguments{
\item{Q}{time histories of the active cases}

\item{R}{time histories of the recovered cases}

\item{D}{time histories of the deceased cases}

\item{Npop}{total population of the country}

\item{E0}{initial number of exposed cases}

\item{I0}{initial number of predicted infectious cases}

\item{time}{a time vector}

\item{alpha}{type I error rate, default is 0.05}

\item{dt}{the time step. This oversamples time to ensure that the algorithm converges}

\item{guess}{initial guess parameters}

\item{ftol}{nls.lm.control object. non-negative numeric. Default is \code{1e-6}}

\item{ptol}{nls.lm.control object. non-negative numeric. Default is \code{1e-6}}

\item{gtol}{nls.lm.control object. non-negative numeric. Default is \code{1e-6}}

\item{diag}{nls.lm.control object. a list or numeric vector containing positive
entries that serve as multiplicative scale factors for the parameters.}

\item{epsfcn}{nls.lm.control object. Default is \code{0.001}}

\item{factor}{nls.lm.control object. Default is \code{100}}

\item{maxfev}{nls.lm.control object. Default is \code{1000}}

\item{maxiter}{nls.lm.control object. Default is \code{100}}

\item{nprint}{nls.lm.control object. Default is \code{1}}

\item{trace}{set \code{TRUE} to trace iteration results}

\item{...}{further arguments}
}
\value{
a list of optimized parameters
}
\description{
Fit SEIQRDP function parameters used in the SEIQRDP function, used to model
the time-evolution of an epidemic outbreak.
}
\examples{
\donttest{
start = "01/01/21"
finish = "04/01/21"
country = "Italy"
dt = 1
f=30

covidData = getDataCOVID(start = start, finish = finish, country = country)
Recovered = covidData$tableRecovered
Deaths = covidData$tableDeaths
Confirmed = covidData$tableConfirmed

if(nrow(Recovered) == 1){
  name = Recovered$CountryRegion
}else{
   name = paste0(Recovered$ProvinceState, " (",Recovered$CountryRegion,")")
}

  recovered = Recovered[ ,5:ncol(covidData$tableRecovered)]
  deaths = Deaths[ ,5:ncol(covidData$tableDeaths)]
  confirmed = Confirmed[ ,5:ncol(covidData$tableConfirmed)]

  Npop = 60000000

  alpha_guess = 0.05
  beta_guess = 0.8
  LT_guess = 7
  Q_guess = 0.8
  lambda_guess = c(0.01,0.001,10)
  kappa_guess = c(0.001,0.001,10)

guess = list(alpha_guess,
            beta_guess,
            1/LT_guess,
            Q_guess,
            lambda_guess[1],
            lambda_guess[2],
            lambda_guess[3],
            kappa_guess[1],
            kappa_guess[2],
            kappa_guess[3])

 Q0 = confirmed[1]-recovered[1]-deaths[1]
 I0 = 0.3*Q0
 E0 = 0.3*Q0
 R0 = recovered[1]
 D0 = deaths[1]

 Active = confirmed-recovered-deaths
 Active[Active<0] <- 0

 Q=Active
 R=recovered
 D = deaths

 time = seq(as.Date(start, format = "\%m/\%d/\%y"), as.Date(finish, format = "\%m/\%d/\%y"), by = "1 day")

 params = fit_SEIQRDP(Q = Active, R = recovered, D = deaths, Npop = Npop, E0 = E0, I0 = I0,
                        time = time, alpha = 0.05, dt = dt, guess = guess, ftol = 1e-6,
                        ptol = 1e-6, gtol = 1e-6, epsfcn = 0.001, factor = 100, maxfev = 1000,
                        maxiter = 100, nprint = 1, trace = TRUE)
}
}
\references{
Peng, L., Yang, W., Zhang, D., Zhuge, C., Hong, L. 2020. “Epidemic analysis of COVID-19 in China by dynamical modeling”, arXiv preprint arXiv:2002.06563.

\url{https://www.mathworks.com/matlabcentral/fileexchange/74545-generalized-seir-epidemic-model-fitting-and-computation}
}
\seealso{
\code{\link{SEIQRDP}} \code{\link{predict_SEIQRDP}}
}
\author{
Selcuk Korkmaz, \email{selcukorkmaz@gmail.com}
}
