% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/neighbourhood.R
\name{pso.nh}
\alias{pso.nh}
\title{Neighbourhood}
\usage{
pso.nh(pop.n = 40, method = "ring", par = 3, iter = 1)
}
\arguments{
\item{pop.n}{integer representing the size of the population.}

\item{method}{string representing the topology to be used for construction
of the neighbourhood. See 'Details' for additional information.}

\item{par}{additional parameters to be passed depending on the \code{method}.}

\item{iter}{iteration number of the genetic algorithm.}
}
\value{
This function returns a list which i-th element is a vector of
particles' indexes which inform i-th particle i.e. neighbourhood of the
i-th particle.
}
\description{
Constructs a neighbourhood of each particle using 
particular topology.
}
\details{
If \code{method = "ring"} then each particle will have 
\code{par[1]} neighbours. By default \code{par[1] = 3}.
See section 3.2.1 of M. Clerc (2012) for 
additional details.
If \code{method = "wheel"} then there is a single (randomly selected) 
particle which informs (and informed by) other particles while there is 
no direct communication between other particles. 
If \code{method = "random"} then each particle randomly informs other
\code{par[1]} particles and itself. Note that duplicates are possible so 
sometimes each particle may inform less then \code{par[1]} particles. 
By default \code{par[1] = 3}.
See section 3.2.2 of M. Clerc (2012) for more details.
If \code{method = "star"} then all particles are fully informed
by each other.
If \code{method = "random2"} then each particle will be self-informed
and informed by the j-th particle with probability \code{par[1]}
(value between 0 and 1). By default \code{par[1] = 0.1}.
}
\examples{
# Prepare random number generator
set.seed(123)

# Ring topology with 5 neighbours
pso.nh(pop.n = 10, method = "ring", par = 5)

# Wheel topology
pso.nh(pop.n = 10, method = "wheel")

# Star topology
pso.nh(pop.n = 10, method = "star")

# Random topology where each particle 
# randomly informs 3 other particles
pso.nh(pop.n = 10, method = "random", par = 3)

# Random2 topology wehere each particle could
# be informed by the other with probability 0.2
pso.nh(pop.n = 10, method = "random2", par = 0.2)

}
\references{
Maurice Clerc (2012). 
Standard Particle Swarm Optimisation.
\emph{HAL archieve}.
}
