% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rss.prop.test.R
\name{rss.prop.test}
\alias{rss.prop.test}
\title{RSS proportion test}
\usage{
rss.prop.test(data, alpha = 0.05, alternative = "two.sided", p0)
}
\arguments{
\item{data}{A numeric data frame of ranked set samples with columns \code{rank} for ranks and \code{y} for data values.}

\item{alpha}{A numeric value specifying the confidence level for the interval.}

\item{alternative}{A character string specifying the alternative hypothesis. Must be one of "two.sided" (default), "greater", or "less".}

\item{p0}{A numeric value indicating the hypothesized proportion for the one-sample test.}
}
\value{
\item{RSS_prop}{The RSS proportion estimate.}
\item{CI}{The confidence interval for the population proportion.}
\item{pstat}{The test statistic for the proportion test.}
\item{p.value}{The p-value for the test.}
}
\description{
The rss.prop.test function performs the population proportion test on ranked set sample data, supporting both balanced and unbalanced RSS designs.
}
\details{
This function performs a proportion test on ranked set samples. It uses the method introduced by Chen et al. (2006), Zamanzade and Mahdizadeh (2020), and Ahn. et al. (2022) . Provide \code{data} as a data frame with columns \code{rank} and \code{y}. The function calculates the test statistic, confidence intervals, and p-value based on the RSS data.
}
\examples{
## Unbalanced RSS with a set size 3 and different sample sizes of 12, 9, 6 for each stratum,
## with a population proportion of 0.6.
rss.prop.data=rss.prop.simulation(H=3,nsamp=c(12,9,6),p=0.6)

## RSS proportion test
rss.prop.test(data=rss.prop.data, alpha=0.05, alternative="two.sided", p0=0.2)

}
\references{
Chen, H., Stasny, E. A., & Wolfe, D. A. (2006). Unbalanced ranked set sampling for estimating a population proportion. Biometrics, 62(1), 150-158.

Zamanzade, E., & Mahdizadeh, M. (2020). Using ranked set sampling with extreme ranks in estimating the population proportion. Statistical methods in medical research, 29(1), 165-177.

Ahn, S., Wang, X., Wang, M., & Lim, J. (2022). On continuity correction for RSS-structured cluster randomized designs with binary outcomes. Metron, 80(3), 383-397.
}
\seealso{
\code{\link{rss.prop.simulation}}: used for simulating Ranked Set Samples (RSS) for proportions, which can serve as input.

\code{\link{rss.prop.sampling}}: used for sampling Ranked Set Samples (RSS) from a population data set for proportions, providing input data.
}
