% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geneviewer.R
\name{GC_annotation}
\alias{GC_annotation}
\title{Add Annotations to a GC_chart}
\usage{
GC_annotation(GC_chart, type = "textAnnotation", cluster = NULL, ...)
}
\arguments{
\item{GC_chart}{A GC chart object to which the annotations will be added.}

\item{type}{Character vector specifying the type of annotations to add. The
default is "text".}

\item{cluster}{Numeric or character vector specifying the clusters to which
annotations should be added.}

\item{...}{Additional parameters for customization of annotations, depending
on the type.}
}
\value{
Updated GC chart object with added annotations.
}
\description{
This function adds annotations to specified clusters within a GC chart.
Annotations can be of various types and are positioned based on provided
coordinates. The types of annotations available are: text, textMarker, line,
arrow, symbol, rectangle, promoter, and terminator.
}
\examples{
genes_data <- data.frame(
  start = c(10, 50, 90, 130, 170, 210),
  end = c(40, 80, 120, 160, 200, 240),
  name = c('Gene 1', 'Gene 2', 'Gene 3', 'Gene 4', 'Gene 5', 'Gene 6'),
  group = c('A', 'A', 'B', 'B', 'A', 'C'),
  cluster = c(1, 1, 1, 2, 2, 2)
)

# Adding annotations to a GC chart
GC_chart(genes_data, cluster = "cluster", group = "group", height = "220px") \%>\%
  GC_annotation(
    type = "textMarker",
    cluster = 1,
    position = 24,
    text = "Gene 1",
    arrowSize = 8
  ) \%>\%
  GC_annotation(
    type = "text",
    text = "feature 1",
    x = 91,
    y = 71
  ) \%>\%
  GC_annotation(
    type = "symbol",
    symbol = "triangle",
    x = 95,
    y = 64,
    size = 10,
    rotation = 180
  ) \%>\%
  GC_annotation(
    type = "terminator",
    x = 81
  ) \%>\%
  GC_annotation(
    type = "promoter",
    x = 49
  ) \%>\%
  # Convenience function to track mouse position on hoover
  GC_trackMouse()

}
\seealso{
\code{\link{GC_trackMouse}}
}
