% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/songs.R
\name{get_song_df}
\alias{get_song_df}
\title{Retrieve metadata for a song}
\usage{
get_song_df(song_id, access_token = genius_token())
}
\arguments{
\item{song_id}{ID of the song (\code{song_id} within an object returned by
\code{\link{search_song}})}

\item{access_token}{Genius' client access token, defaults to \code{genius_token}}
}
\value{
a tibble
}
\description{
The Genius API lets you search for meta data for a song, given a song ID.
\code{get_song_meta} returns this data in a tidy, but reduced, format.
}
\examples{
\dontrun{
get_song_df(song_id = 3039923)
}

}
\seealso{
See \code{\link{get_song}} to return data in full as a list.

Other song: 
\code{\link{get_song}()},
\code{\link{tidy_album_performances}()},
\code{\link{tidy_song_performances}()},
\code{\link{tidy_song_producers}()},
\code{\link{tidy_song_relationships}()},
\code{\link{tidy_song_writers}()}
}
\concept{song}
