pSB <-
function(q, lambda=0, lower.tail=TRUE, log.p=FALSE)
{
if(lambda< -1 | lambda>1) stop("lambda must be between -1 and 1")
delta=(1-lambda)/2
Fy <- log(q)+log1p(2*delta*(q-1)-q+1)
Fy <- ifelse(q <= 0, -Inf, Fy)
Fy <- ifelse(q >= 1, 0, Fy)
if(log.p == FALSE) Fy <- exp(Fy)
if(lower.tail==FALSE) Fy<-1-Fy
Fy
}
